/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.entities;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.database.entities.EntityScopeResponse;
import org.graylog2.database.entities.EntityScopeService;
import org.graylog2.database.entities.EntityScopes;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="EntityScope", description="Provide a list of available Entity Scopes", tags={"cloud"})
@Produces(value={"application/json"})
@Path(value="/entity_scopes")
@RequiresAuthentication
public class EntityScopeResource
extends RestResource {
    private final EntityScopeService entityScopeService;

    @Inject
    public EntityScopeResource(EntityScopeService entityScopeService) {
        this.entityScopeService = entityScopeService;
    }

    @ApiOperation(value="Generate a mapping of available Entity Scopes")
    @GET
    public EntityScopes getAllEntityScopes() {
        Map<String, EntityScopeResponse> scopes = this.entityScopeService.getEntityScopes().stream().collect(Collectors.toMap(e -> e.getName().toUpperCase(Locale.ROOT), EntityScopeResponse::of));
        return EntityScopes.create(scopes);
    }
}

