/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.grok;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.krakens.grok.api.Grok;
import io.krakens.grok.api.GrokCompiler;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.grok.GrokPatternsDeletedEvent;
import org.graylog2.grok.GrokPatternsUpdatedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GrokPatternRegistry {
    private static final Logger log = LoggerFactory.getLogger(GrokPatternRegistry.class);
    private final GrokPatternService grokPatternService;
    private final AtomicReference<Set<GrokPattern>> patterns = new AtomicReference(Collections.emptySet());
    private final LoadingCache<String, Grok> grokCache;
    private final LoadingCache<String, Grok> grokCacheNamedOnly;

    @Inject
    public GrokPatternRegistry(EventBus serverEventBus, GrokPatternService grokPatternService, @Named(value="daemonScheduler") ScheduledExecutorService daemonExecutor) {
        this.grokPatternService = grokPatternService;
        this.grokCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build(CacheLoader.asyncReloading((CacheLoader)new GrokReloader(false), (Executor)daemonExecutor));
        this.grokCacheNamedOnly = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build(CacheLoader.asyncReloading((CacheLoader)new GrokReloader(true), (Executor)daemonExecutor));
        this.reload();
        serverEventBus.register((Object)this);
    }

    @Subscribe
    public void grokPatternsUpdated(GrokPatternsUpdatedEvent event) {
        this.reload();
    }

    @Subscribe
    public void grokPatternsDeleted(GrokPatternsDeletedEvent event) {
        this.reload();
    }

    public boolean grokPatternExists(String patternName) {
        return this.patterns.get().stream().anyMatch(pattern -> pattern.name().equals(patternName));
    }

    public Grok cachedGrokForPattern(String pattern) {
        return this.cachedGrokForPattern(pattern, false);
    }

    public Grok cachedGrokForPattern(String pattern, boolean namedCapturesOnly) {
        try {
            if (namedCapturesOnly) {
                return (Grok)this.grokCacheNamedOnly.get((Object)pattern);
            }
            return (Grok)this.grokCache.get((Object)pattern);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            log.error("Unable to load grok pattern {} into cache", (Object)pattern, (Object)rootCause);
            throw new RuntimeException(rootCause);
        }
    }

    private void reload() {
        Set<GrokPattern> grokPatterns = this.grokPatternService.loadAll();
        this.patterns.set(grokPatterns);
        this.grokCache.invalidateAll();
        this.grokCacheNamedOnly.invalidateAll();
    }

    public Set<GrokPattern> patterns() {
        return this.patterns.get();
    }

    private class GrokReloader
    extends CacheLoader<String, Grok> {
        private final boolean namedCapturesOnly;

        GrokReloader(boolean namedCapturesOnly) {
            this.namedCapturesOnly = namedCapturesOnly;
        }

        public Grok load(@Nonnull String pattern) throws Exception {
            GrokCompiler grokCompiler = GrokCompiler.newInstance();
            for (GrokPattern grokPattern : GrokPatternRegistry.this.patterns()) {
                grokCompiler.register(grokPattern.name(), grokPattern.pattern());
            }
            return grokCompiler.compile(pattern, this.namedCapturesOnly);
        }
    }
}

