/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes.utils;

import java.util.Collection;
import java.util.HashMap;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.FieldTypeMapper;
import org.graylog2.indexer.indexset.CustomFieldMappings;
import org.graylog2.indexer.indexset.profile.IndexFieldTypeProfile;
import org.graylog2.plugin.Message;
import org.graylog2.rest.resources.system.indexer.responses.FieldTypeOrigin;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetFieldType;

public class FieldTypeDTOsMerger {
    public Collection<IndexSetFieldType> merge(Collection<FieldTypeDTO> fromNewerIndex, Collection<FieldTypeDTO> fromOlderIndex, CustomFieldMappings customFieldMappings, IndexFieldTypeProfile profile) {
        HashMap result = new HashMap();
        if (fromNewerIndex != null) {
            fromNewerIndex.forEach(dto -> result.put(dto.fieldName(), this.toIndexSetFieldType((FieldTypeDTO)dto, FieldTypeOrigin.INDEX)));
        }
        if (fromOlderIndex != null) {
            fromOlderIndex.forEach(dto -> result.putIfAbsent(dto.fieldName(), this.toIndexSetFieldType((FieldTypeDTO)dto, FieldTypeOrigin.INDEX)));
        }
        if (profile != null) {
            profile.customFieldMappings().forEach(profileMapping -> result.put(profileMapping.fieldName(), this.toIndexSetFieldType(profileMapping.toFieldTypeDTO(), FieldTypeOrigin.PROFILE)));
        }
        if (customFieldMappings != null) {
            customFieldMappings.forEach(customFieldMapping -> {
                IndexSetFieldType indexSetFieldTypeFromPrevSources = (IndexSetFieldType)result.get(customFieldMapping.fieldName());
                result.put(customFieldMapping.fieldName(), this.toIndexSetFieldType(customFieldMapping.toFieldTypeDTO(), indexSetFieldTypeFromPrevSources != null && indexSetFieldTypeFromPrevSources.origin() == FieldTypeOrigin.PROFILE ? FieldTypeOrigin.OVERRIDDEN_PROFILE : FieldTypeOrigin.OVERRIDDEN_INDEX));
            });
        }
        return result.values();
    }

    private IndexSetFieldType toIndexSetFieldType(FieldTypeDTO fieldTypeDTO, FieldTypeOrigin origin) {
        return new IndexSetFieldType(fieldTypeDTO.fieldName(), CustomFieldMappings.REVERSE_TYPES.get(FieldTypeMapper.TYPE_MAP.get(fieldTypeDTO.physicalType())), origin, Message.FIELDS_UNCHANGEABLE_BY_CUSTOM_MAPPINGS.contains((Object)fieldTypeDTO.fieldName()));
    }
}

