/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.healing;

import com.google.inject.assistedinject.AssistedInject;
import java.util.EnumSet;
import org.graylog2.buffers.Buffers;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.system.jobs.SystemJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixDeflectorByMoveJob
extends SystemJob {
    private static final Logger LOG = LoggerFactory.getLogger(FixDeflectorByMoveJob.class);
    public static final int MAX_CONCURRENCY = 1;
    private final IndexSetRegistry indexSetRegistry;
    private final ServerStatus serverStatus;
    private final Indices indices;
    private final ActivityWriter activityWriter;
    private final Buffers bufferSynchronizer;
    private final NotificationService notificationService;
    private int progress = 0;

    @AssistedInject
    public FixDeflectorByMoveJob(IndexSetRegistry indexSetRegistry, Indices indices, ServerStatus serverStatus, ActivityWriter activityWriter, Buffers bufferSynchronizer, NotificationService notificationService) {
        this.indexSetRegistry = indexSetRegistry;
        this.indices = indices;
        this.serverStatus = serverStatus;
        this.activityWriter = activityWriter;
        this.bufferSynchronizer = bufferSynchronizer;
        this.notificationService = notificationService;
    }

    @Override
    public void execute() {
        this.indexSetRegistry.forEach(this::doExecute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(IndexSet indexSet) {
        if (!indexSet.getConfig().isWritable()) {
            LOG.debug("No need to fix deflector for non-writable index set <{}> ({})", (Object)indexSet.getConfig().id(), (Object)indexSet.getConfig().title());
            return;
        }
        if (indexSet.isUp() || !this.indices.exists(indexSet.getWriteIndexAlias())) {
            LOG.error("There is no index <{}>. No need to run this job. Aborting.", (Object)indexSet.getWriteIndexAlias());
            return;
        }
        LOG.info("Attempting to fix deflector with move strategy.");
        boolean wasProcessing = true;
        try {
            wasProcessing = this.serverStatus.isProcessing();
            this.serverStatus.pauseMessageProcessing();
            this.progress = 5;
            this.bufferSynchronizer.waitForEmptyBuffers(EnumSet.of(Buffers.Type.PROCESS, Buffers.Type.OUTPUT));
            this.progress = 10;
            String newTarget = null;
            try {
                newTarget = indexSet.getNewestIndex();
                LOG.info("Starting to move <{}> to <{}>.", (Object)indexSet.getWriteIndexAlias(), (Object)newTarget);
                this.indices.move(indexSet.getWriteIndexAlias(), newTarget);
            }
            catch (Exception e) {
                LOG.error("Moving index failed. Rolling back.", (Throwable)e);
                if (newTarget != null) {
                    this.indices.delete(newTarget);
                }
                throw new RuntimeException(e);
            }
            LOG.info("Done moving deflector index.");
            this.progress = 85;
            LOG.info("Deleting <{}> index.", (Object)indexSet.getWriteIndexAlias());
            this.indices.delete(indexSet.getWriteIndexAlias());
            this.progress = 90;
            indexSet.setUp();
            this.progress = 95;
        }
        finally {
            this.serverStatus.unlockProcessingPause();
            if (wasProcessing) {
                this.serverStatus.resumeMessageProcessing();
            }
        }
        this.progress = 90;
        this.activityWriter.write(new Activity("Notification condition [" + String.valueOf((Object)Notification.Type.DEFLECTOR_EXISTS_AS_INDEX) + "] has been fixed.", this.getClass()));
        this.notificationService.fixed(Notification.Type.DEFLECTOR_EXISTS_AS_INDEX);
        this.progress = 100;
        LOG.info("Finished.");
    }

    @Override
    public void requestCancel() {
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int maxConcurrency() {
        return 1;
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Tries to fix a broken deflector alias by converting the deflector index to a valid index. Triggered by hand after a notification. This operation can take some time depending on the number of messages that were already written into the deflector index.";
    }

    @Override
    public String getClassName() {
        return this.getClass().getCanonicalName();
    }

    public static interface Factory {
        public FixDeflectorByMoveJob create();
    }
}

