/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.messages;

import java.io.IOException;
import java.util.List;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.messages.IndexingRequest;
import org.graylog2.indexer.messages.IndexingResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedBulkIndexer {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkedBulkIndexer.class);

    public IndexingResults index(List<IndexingRequest> messageList, BulkIndex bulkIndex) throws IOException {
        if (messageList.isEmpty()) {
            return IndexingResults.empty();
        }
        int chunkSize = messageList.size();
        int offset = 0;
        IndexingResults.Builder accumulatedResults = IndexingResults.Builder.create();
        while (true) {
            try {
                IndexingResults results = bulkIndex.apply(new Chunk(messageList, offset, chunkSize));
                accumulatedResults.addResults(results);
                return accumulatedResults.build();
            }
            catch (EntityTooLargeException e) {
                if (e instanceof TooManyRequestsException) {
                    LOG.warn("Bulk index failed with 'Too many requests' error. Retrying by splitting up batch size <{}>.", (Object)chunkSize);
                } else {
                    LOG.warn("Bulk index failed with 'Request Entity Too Large' error. Retrying by splitting up batch size <{}>.", (Object)chunkSize);
                }
                if (chunkSize == messageList.size()) {
                    LOG.warn("Consider lowering the \"output_batch_size\" setting. Or resizing your Search cluster");
                }
                offset += e.indexedSuccessfully;
                accumulatedResults.addResults(e.previousResults);
                if ((chunkSize /= 2) != 0) continue;
                throw new ElasticsearchException("Bulk index cannot split output batch any further.");
            }
            break;
        }
    }

    public static class Chunk {
        public final List<IndexingRequest> requests;
        public final int offset;
        public final int size;

        Chunk(List<IndexingRequest> requests, int offset, int size) {
            this.requests = requests;
            this.offset = offset;
            this.size = size;
        }
    }

    public static interface BulkIndex {
        public IndexingResults apply(Chunk var1) throws EntityTooLargeException, IOException;
    }

    public static class EntityTooLargeException
    extends Exception {
        public final int indexedSuccessfully;
        public final IndexingResults previousResults;

        public EntityTooLargeException(int indexedSuccessfully, IndexingResults previousResults) {
            this.indexedSuccessfully = indexedSuccessfully;
            this.previousResults = previousResults;
        }
    }

    public static class TooManyRequestsException
    extends EntityTooLargeException {
        public TooManyRequestsException(int indexedSuccessfully, IndexingResults previousResults) {
            super(indexedSuccessfully, previousResults);
        }
    }
}

