/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog2.indexer.results.HighlightParser;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ResultMessageFactory;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;

public class DefaultResultMessageFactory
implements ResultMessageFactory {
    private final MessageFactory messageFactory;

    @Inject
    public DefaultResultMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public ResultMessage parseFromSource(String id, String index, Map<String, Object> message) {
        return this.parseFromSource(id, index, message, Collections.emptyMap());
    }

    @Override
    public ResultMessage parseFromSource(String id, String index, Map<String, Object> message, Map<String, List<String>> highlight) {
        return new ResultMessage(this.messageFactory, id, index, message, HighlightParser.extractHighlightRanges(highlight));
    }

    @Override
    public ResultMessage createFromMessage(Message message) {
        ResultMessage m = new ResultMessage(this.messageFactory);
        m.setMessage(message);
        return m;
    }
}

