/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.commons.lang3.ObjectUtils;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.events.inputs.IOStateChangedEvent;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InputStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(InputStateListener.class);
    private final NotificationService notificationService;
    private final ActivityWriter activityWriter;
    private final ServerStatus serverStatus;

    @Inject
    public InputStateListener(EventBus eventBus, NotificationService notificationService, ActivityWriter activityWriter, ServerStatus serverStatus) {
        this.notificationService = notificationService;
        this.activityWriter = activityWriter;
        this.serverStatus = serverStatus;
        eventBus.register((Object)this);
    }

    @Subscribe
    public void inputStateChanged(IOStateChangedEvent<MessageInput> event) {
        IOState<MessageInput> state = event.changedState();
        MessageInput input = state.getStoppable();
        String msg = StringUtils.f("Input %s is in state %s", new Object[]{input.toIdentifier(), event.newState()});
        if (state.getDetailedMessage() != null) {
            msg = StringUtils.f("Input %s is in state %s [%s]", new Object[]{input.toIdentifier(), event.newState(), state.getDetailedMessage()});
        }
        switch (event.newState()) {
            case FAILED: 
            case FAILING: {
                this.activityWriter.write(new Activity(msg, InputRegistry.class));
                Notification notification = this.notificationService.buildNow();
                Notification.Type type = event.newState().equals((Object)IOState.Type.FAILING) ? Notification.Type.INPUT_FAILING : Notification.Type.INPUT_FAILED_TO_START;
                notification.addType(type).addSeverity(Notification.Severity.NORMAL);
                notification.addKey(input.getId());
                notification.addNode(this.serverStatus.getNodeId().toString());
                notification.addDetail("input_id", input.toIdentifier());
                notification.addDetail("reason", ObjectUtils.defaultIfNull((Object)state.getDetailedMessage(), (Object)""));
                this.notificationService.publishIfFirst(notification);
                break;
            }
            case RUNNING: {
                this.notificationService.fixed(Notification.Type.NO_INPUT_RUNNING);
                this.notificationService.fixed(Notification.Type.INPUT_FAILING, input.getId());
                this.notificationService.fixed(Notification.Type.INPUT_FAILED_TO_START, input.getId());
            }
            default: {
                this.activityWriter.write(new Activity(msg, InputStateListener.class));
            }
        }
        LOG.debug("Input State of {} changed: {} -> {}", new Object[]{input.toIdentifier(), event.oldState(), event.newState()});
        LOG.info("Input {} is now {}", (Object)input.toIdentifier(), (Object)event.newState());
    }
}

