/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.misc.jsonpath;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import jakarta.inject.Inject;
import org.graylog2.inputs.codecs.JsonPathCodec;
import org.graylog2.inputs.transports.HttpPollTransport;
import org.graylog2.plugin.DocsHelper;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.inputs.CloudCompatible;
import org.graylog2.plugin.inputs.MessageInput;

@CloudCompatible
public class JsonPathInput
extends MessageInput {
    private static final String NAME = "JSON path value from HTTP API";
    private final Configuration configuration;

    @AssistedInject
    public JsonPathInput(@Assisted Configuration configuration, HttpPollTransport.Factory transport, JsonPathCodec.Factory codec, MetricRegistry metricRegistry, LocalMetricRegistry localRegistry, Config config, Descriptor descriptor, ServerStatus serverStatus) {
        super(metricRegistry, configuration, transport.create(configuration), localRegistry, codec.create(configuration), config, descriptor, serverStatus);
        this.configuration = configuration;
    }

    @Override
    public boolean onlyOnePerCluster() {
        return true;
    }

    @Override
    public void checkConfiguration() throws ConfigurationException {
        super.checkConfiguration();
        if (this.configuration.stringIsSet("http_method") && ("PUT".equals(this.configuration.getString("http_method")) || "POST".equals(this.configuration.getString("http_method")))) {
            if (!this.configuration.stringIsSet("content_type")) {
                throw new ConfigurationException("HTTP content type must be selected if using POST or PUT.");
            }
            if (!this.configuration.stringIsSet("http_body")) {
                throw new ConfigurationException("HTTP body must be filled if using POST or PUT.");
            }
        }
    }

    public static class Config
    extends MessageInput.Config {
        @Inject
        public Config(HttpPollTransport.Factory transport, JsonPathCodec.Factory codec) {
            super(transport.getConfig(), codec.getConfig());
        }
    }

    public static class Descriptor
    extends MessageInput.Descriptor {
        @Inject
        public Descriptor() {
            super(JsonPathInput.NAME, false, DocsHelper.PAGE_SENDING_JSONPATH.toString());
        }

        @Override
        public boolean isCloudCompatible() {
            return true;
        }
    }

    public static interface Factory
    extends MessageInput.Factory<JsonPathInput> {
        @Override
        public JsonPathInput create(Configuration var1);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

