/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.graylog2.lookup.AutoValue_LookupDefaultSingleValue;
import org.graylog2.lookup.LookupDefaultValue;

@JsonAutoDetect
@JsonDeserialize(builder=AutoValue_LookupDefaultSingleValue.Builder.class)
@AutoValue
public abstract class LookupDefaultSingleValue
implements LookupDefaultValue {
    @Override
    @JsonProperty(value="value_string")
    public abstract String valueString();

    @Override
    @JsonProperty(value="value_type")
    public abstract LookupDefaultValue.Type valueType();

    @Override
    @JsonProperty(value="value")
    @Nullable
    public abstract Object value();

    @Override
    public boolean isSet() {
        return this.valueType() != LookupDefaultValue.Type.NULL;
    }

    public static LookupDefaultSingleValue create(String valueString, LookupDefaultValue.Type valueType) {
        Object value;
        Objects.requireNonNull(valueString, "valueString cannot be null");
        Objects.requireNonNull(valueType, "valueType cannot be null");
        try {
            switch (valueType) {
                case STRING: {
                    value = valueString;
                    break;
                }
                case NUMBER: {
                    value = OBJECT_MAPPER.convertValue((Object)valueString, Number.class);
                    break;
                }
                case BOOLEAN: {
                    value = Boolean.parseBoolean(valueString);
                    break;
                }
                case NULL: {
                    value = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Could not convert <" + valueString + "> to single value type <" + String.valueOf((Object)valueType) + ">");
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse JSON " + valueType.toString().toLowerCase(Locale.ENGLISH) + " value <" + valueString + ">", e);
        }
        return LookupDefaultSingleValue.builder().valueString(valueString).valueType(valueType).value(value).build();
    }

    public static Builder builder() {
        return new AutoValue_LookupDefaultSingleValue.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="value_string")
        public abstract Builder valueString(String var1);

        @JsonProperty(value="value_type")
        public abstract Builder valueType(LookupDefaultValue.Type var1);

        @JsonProperty(value="value")
        public abstract Builder value(@Nullable Object var1);

        public abstract LookupDefaultSingleValue build();
    }
}

