/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Objects;
import org.graylog2.migrations.MigrationType;

public abstract class Migration
implements Comparable<Migration> {
    private static final Comparator<Migration> COMPARATOR = Comparator.comparing(migration -> migration.createdAt().toString() + migration.getClass().getName());

    public abstract ZonedDateTime createdAt();

    public abstract void upgrade();

    public MigrationType migrationType() {
        return MigrationType.STANDARD;
    }

    @Override
    public int compareTo(Migration that) {
        return COMPARATOR.compare(this, that);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt(), this.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Migration that = (Migration)o;
        return Objects.equals(this.createdAt(), that.createdAt());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.createdAt().format(DateTimeFormatter.ISO_DATE_TIME) + "}";
    }
}

