/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.graylog2.shared.SuppressForbidden;

public class ResolvableInetSocketAddress {
    private final InetSocketAddress inetSocketAddress;
    private boolean reverseLookedUp = false;

    @VisibleForTesting
    protected ResolvableInetSocketAddress(InetSocketAddress inetSocketAddress) {
        this.inetSocketAddress = Objects.requireNonNull(inetSocketAddress);
    }

    public static ResolvableInetSocketAddress wrap(InetSocketAddress socketAddress) {
        if (socketAddress == null) {
            return null;
        }
        return new ResolvableInetSocketAddress(socketAddress);
    }

    @SuppressForbidden(value="Deliberate invocation")
    public String reverseLookup() {
        String hostName = this.inetSocketAddress.getHostName();
        this.reverseLookedUp = true;
        return hostName;
    }

    public boolean isReverseLookedUp() {
        return this.reverseLookedUp;
    }

    public boolean isUnresolved() {
        return this.inetSocketAddress.isUnresolved();
    }

    public InetAddress getAddress() {
        return this.inetSocketAddress.getAddress();
    }

    public byte[] getAddressBytes() {
        return this.inetSocketAddress.getAddress().getAddress();
    }

    public int getPort() {
        return this.inetSocketAddress.getPort();
    }

    @SuppressForbidden(value="Deliberate invocation")
    public String getHostName() {
        if (this.isReverseLookedUp()) {
            return this.inetSocketAddress.getHostName();
        }
        return null;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.inetSocketAddress;
    }

    public String toString() {
        if (this.isReverseLookedUp()) {
            return this.getHostName() + ":" + this.getPort();
        }
        return this.getAddress().getHostAddress() + ":" + this.getPort();
    }
}

