/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.journal;

import com.eaio.uuid.UUID;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.UninitializedMessageException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog2.plugin.ResolvableInetSocketAddress;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.journal.JournalMessages;
import org.graylog2.plugin.system.NodeId;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMessage
implements Serializable {
    public static final byte CURRENT_VERSION = 1;
    private static final Logger log = LoggerFactory.getLogger(RawMessage.class);
    private final transient JournalMessages.JournalMessage.Builder msgBuilder;
    private final UUID id;
    private Object messageQueueId;
    private int sequenceNr;
    private Configuration codecConfig;

    public RawMessage(@Nonnull byte[] payload) {
        this(payload, (ResolvableInetSocketAddress)null);
    }

    public RawMessage(@Nonnull byte[] payload, @Nullable InetSocketAddress remoteAddress) {
        this(Long.MIN_VALUE, new UUID(), Tools.nowUTC(), ResolvableInetSocketAddress.wrap(remoteAddress), payload);
    }

    public RawMessage(@Nonnull byte[] payload, @Nullable ResolvableInetSocketAddress remoteAddress) {
        this(Long.MIN_VALUE, new UUID(), Tools.nowUTC(), remoteAddress, payload);
    }

    public RawMessage(long journalOffset, @Nonnull UUID id, DateTime timestamp, @Nullable ResolvableInetSocketAddress remoteAddress, @Nonnull byte[] payload) {
        Preconditions.checkNotNull((Object)id, (Object)"The message id must not be null!");
        Preconditions.checkNotNull((Object)payload, (Object)"The message payload must not be null!");
        this.sequenceNr = 0;
        if (payload.length == 0 && log.isTraceEnabled()) {
            log.trace("The message payload should not be empty, message {} from {} will be discarded.", new Object[]{id, remoteAddress == null ? "unknown" : remoteAddress, new Throwable()});
        }
        this.msgBuilder = JournalMessages.JournalMessage.newBuilder();
        this.messageQueueId = journalOffset;
        this.msgBuilder.setVersion(1);
        this.id = id;
        this.msgBuilder.setUuidTime(id.time);
        this.msgBuilder.setUuidClockseq(id.clockSeqAndNode);
        this.msgBuilder.setTimestamp(timestamp.getMillis());
        if (null != remoteAddress) {
            this.setRemoteAddress(remoteAddress);
        }
        this.msgBuilder.setPayload(ByteString.copyFrom((byte[])payload));
    }

    public void addSourceNode(String sourceInputId, NodeId nodeId) {
        this.msgBuilder.addSourceNodesBuilder().setInputId(sourceInputId).setId(nodeId.getNodeId()).setType(JournalMessages.SourceNode.Type.SERVER);
    }

    public RawMessage(JournalMessages.JournalMessage journalMessage, Object messageQueueId) {
        this.messageQueueId = messageQueueId;
        this.sequenceNr = journalMessage.getSequenceNr();
        this.id = new UUID(journalMessage.getUuidTime(), journalMessage.getUuidClockseq());
        this.msgBuilder = JournalMessages.JournalMessage.newBuilder(journalMessage);
        this.codecConfig = Configuration.deserializeFromJson(journalMessage.getCodec().getConfig());
    }

    @Nullable
    public static RawMessage decode(byte[] buffer, Object messageQueueId) {
        if (buffer == null) {
            log.error("Cannot read <null> message from journal, ignoring this message.");
            return null;
        }
        try {
            JournalMessages.JournalMessage journalMessage = JournalMessages.JournalMessage.parseFrom(buffer);
            return new RawMessage(journalMessage, messageQueueId);
        }
        catch (IOException e) {
            log.error("Cannot read raw message from journal, ignoring this message.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static RawMessage decode(byte[] buffer, long journalOffset) {
        try {
            JournalMessages.JournalMessage journalMessage = JournalMessages.JournalMessage.parseFrom(buffer);
            return new RawMessage(journalMessage, journalOffset);
        }
        catch (IOException e) {
            log.error("Cannot read raw message from journal, ignoring this message.", (Throwable)e);
            return null;
        }
    }

    public byte[] encode() {
        try {
            JournalMessages.CodecInfo codec = this.msgBuilder.getCodec();
            JournalMessages.CodecInfo.Builder builder = JournalMessages.CodecInfo.newBuilder(codec);
            String codecConfigJson = this.codecConfig.serializeToJson();
            if (codecConfigJson != null) {
                builder.setConfig(codecConfigJson);
            }
            this.msgBuilder.setCodec(builder.build());
            JournalMessages.JournalMessage journalMessage = this.msgBuilder.build();
            return journalMessage.toByteArray();
        }
        catch (UninitializedMessageException e) {
            log.error("Unable to write RawMessage to journal because required fields are missing, this message will be discarded. This is a bug.", (Throwable)e);
            return null;
        }
    }

    public int getVersion() {
        return this.msgBuilder.getVersion();
    }

    public DateTime getTimestamp() {
        return new DateTime(this.msgBuilder.getTimestamp(), DateTimeZone.UTC);
    }

    public byte[] getPayload() {
        return this.msgBuilder.getPayload().toByteArray();
    }

    public UUID getId() {
        return this.id;
    }

    public byte[] getIdBytes() {
        long time = this.id.getTime();
        long clockSeqAndNode = this.id.getClockSeqAndNode();
        return ByteBuffer.allocate(16).putLong(time).putLong(clockSeqAndNode).array();
    }

    @Nullable
    public ResolvableInetSocketAddress getRemoteAddress() {
        if (this.msgBuilder.hasRemote()) {
            InetAddress inetAddr;
            JournalMessages.RemoteAddress address = this.msgBuilder.getRemote();
            try {
                inetAddr = InetAddress.getByAddress(address.getResolved(), address.getAddress().toByteArray());
            }
            catch (UnknownHostException e) {
                log.warn("Malformed InetAddress for message {}, expected 4 or 16 bytes, but got {} bytes", (Object)this.id, (Object)address.getAddress().toByteArray());
                return null;
            }
            int port = address.hasPort() ? address.getPort() : 0;
            return ResolvableInetSocketAddress.wrap(new InetSocketAddress(inetAddr, port));
        }
        return null;
    }

    public void setRemoteAddress(ResolvableInetSocketAddress address) {
        JournalMessages.RemoteAddress.Builder builder = this.msgBuilder.getRemoteBuilder();
        builder.setAddress(ByteString.copyFrom((byte[])address.getAddressBytes())).setPort(address.getPort());
        if (address.isReverseLookedUp()) {
            builder.setResolved(address.getHostName());
        }
    }

    public String getCodecName() {
        return this.msgBuilder.getCodecBuilder().getName();
    }

    public void setCodecName(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"The payload type must not be null or empty!");
        this.msgBuilder.getCodecBuilder().setName(name);
    }

    public Configuration getCodecConfig() {
        return this.codecConfig;
    }

    public void setCodecConfig(Configuration codecConfig) {
        this.codecConfig = codecConfig;
    }

    public List<SourceNode> getSourceNodes() {
        ArrayList list = Lists.newArrayList();
        for (JournalMessages.SourceNode node : this.msgBuilder.getSourceNodesList()) {
            list.add(new SourceNode(node));
        }
        return list;
    }

    public void setSequenceNr(int sequenceNr) {
        this.sequenceNr = sequenceNr;
        this.msgBuilder.setSequenceNr(sequenceNr);
    }

    public int getSequenceNr() {
        return this.sequenceNr;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.add("id", (Object)this.getId()).add("messageQueueId", this.getMessageQueueId()).add("codec", (Object)this.getCodecName()).add("payloadSize", this.getPayload().length).add("timestamp", (Object)this.getTimestamp()).add("seqenceNr", this.getSequenceNr());
        if (this.getRemoteAddress() != null) {
            helper.add("remoteAddress", (Object)this.getRemoteAddress().getInetSocketAddress().toString());
        }
        return helper.toString();
    }

    public Object getMessageQueueId() {
        return this.messageQueueId;
    }

    @Deprecated
    public long getJournalOffset() {
        if (this.messageQueueId == null) {
            return Long.MIN_VALUE;
        }
        return (Long)this.messageQueueId;
    }

    public static class SourceNode {
        public String nodeId;
        public String inputId;
        public Type type;

        public SourceNode(JournalMessages.SourceNode node) {
            this.nodeId = node.getId();
            this.inputId = node.getInputId();
            switch (node.getType()) {
                case SERVER: {
                    this.type = Type.SERVER;
                    break;
                }
                case RADIO: {
                    this.type = Type.RADIO;
                }
            }
        }

        public static enum Type {
            SERVER,
            RADIO;

        }
    }
}

