/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.entities.preferences;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotEmpty;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.security.UserContext;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.rest.resources.entities.preferences.model.EntityListPreferences;
import org.graylog2.rest.resources.entities.preferences.model.StoredEntityListPreferences;
import org.graylog2.rest.resources.entities.preferences.model.StoredEntityListPreferencesId;
import org.graylog2.rest.resources.entities.preferences.service.EntityListPreferencesService;

@RequiresAuthentication
@Api(value="EntityLists", description="Entity Lists Preferences", tags={"cloud"})
@Path(value="/entitylists/preferences")
public class EntityListPreferencesResource {
    private final EntityListPreferencesService entityListPreferencesService;

    @Inject
    public EntityListPreferencesResource(EntityListPreferencesService entityListPreferencesService) {
        this.entityListPreferencesService = entityListPreferencesService;
    }

    @POST
    @Path(value="/{entity_list_id}")
    @Timed
    @ApiOperation(value="Create or update user preferences for certain entity list")
    @Consumes(value={"application/json"})
    @NoAuditEvent(value="Audit logs are not stored for entity list preferences")
    public Response create(@ApiParam(name="JSON body", required=true) EntityListPreferences entityListPreferences, @ApiParam(name="entity_list_id", required=true) @PathParam(value="entity_list_id") @NotEmpty String entityListId, @Context UserContext userContext) throws ValidationException {
        String currentUserId = userContext.getUserId();
        StoredEntityListPreferencesId complexId = StoredEntityListPreferencesId.builder().userId(currentUserId).entityListId(entityListId).build();
        StoredEntityListPreferences storedPreferences = StoredEntityListPreferences.builder().preferencesId(complexId).preferences(entityListPreferences).build();
        boolean successful = this.entityListPreferencesService.save(storedPreferences);
        if (successful) {
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @GET
    @Path(value="/{entity_list_id}")
    @Timed
    @ApiOperation(value="Get preferences for user's entity list", response=EntityListPreferences.class)
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Preferences not found.")})
    public EntityListPreferences get(@ApiParam(name="entity_list_id", required=true) @PathParam(value="entity_list_id") @NotEmpty String entityListId, @Context UserContext userContext) throws NotFoundException {
        String currentUserId = userContext.getUserId();
        StoredEntityListPreferencesId complexId = StoredEntityListPreferencesId.builder().userId(currentUserId).entityListId(entityListId).build();
        StoredEntityListPreferences entityListPreferences = this.entityListPreferencesService.get(complexId);
        if (entityListPreferences == null) {
            return null;
        }
        return entityListPreferences.preferences();
    }
}

