/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.rules;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.database.NotFoundException;
import org.graylog2.rest.resources.streams.rules.responses.StreamRuleInputsList;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.input.StreamRuleInputsProvider;

@RequiresAuthentication
@Api(value="StreamRulesInputs", description="Provide stream rule inputs", tags={"cloud"})
@Path(value="/streams/rules/inputs")
public class StreamRuleInputsResource
extends RestResource {
    private final Set<StreamRuleInputsProvider> streamRuleInputsProviders;

    @Inject
    public StreamRuleInputsResource(Set<StreamRuleInputsProvider> streamRuleInputsProviders) {
        this.streamRuleInputsProviders = streamRuleInputsProviders;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all inputs for stream rules")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"inputs:read"})
    public StreamRuleInputsList list() throws NotFoundException {
        return StreamRuleInputsList.create(this.streamRuleInputsProviders.stream().map(StreamRuleInputsProvider::inputs).flatMap(Collection::stream).collect(Collectors.toSet()));
    }
}

