/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.configuration.IndexSetsDefaultConfiguration;
import org.graylog2.indexer.IndexSetValidator;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.Duration;

@RequiresAuthentication
@Api(value="System/IndexSetDefaults", description="Index set defaults")
@Path(value="/system/indices/index_set_defaults")
@Produces(value={"application/json"})
public class IndexSetDefaultsResource
extends RestResource {
    private final IndexSetValidator indexSetValidator;
    private final ClusterConfigService clusterConfigService;
    private final Validator validator;

    @Inject
    public IndexSetDefaultsResource(IndexSetValidator indexSetValidator, ClusterConfigService clusterConfigService, Validator validator) {
        this.indexSetValidator = indexSetValidator;
        this.clusterConfigService = clusterConfigService;
        this.validator = validator;
    }

    private static String buildFieldError(String field, String message) {
        return StringUtils.f("Invalid value for field [%s]: %s", field, message);
    }

    @PUT
    @Timed
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update index set defaults configuration")
    @RequiresPermissions(value={"clusterconfigentry:create", "clusterconfigentry:edit"})
    @AuditEvent(type="server:cluster_configuration:update")
    public Response update(@ApiParam(name="body", value="The payload of the index set defaults configuration", required=true) @NotNull IndexSetsDefaultConfiguration config) throws IOException {
        this.validator.validate((Object)config, new Class[0]).forEach(v -> {
            throw new BadRequestException(IndexSetDefaultsResource.buildFieldError(v.getPropertyPath().toString(), v.getMessage()));
        });
        IndexSetValidator.Violation violation = this.indexSetValidator.validateRefreshInterval(Duration.standardSeconds((long)config.fieldTypeRefreshIntervalUnit().toSeconds(config.fieldTypeRefreshInterval())));
        if (violation != null) {
            throw new BadRequestException(IndexSetDefaultsResource.buildFieldError("field_type_refresh_interval", violation.message()));
        }
        violation = this.indexSetValidator.validateRotation(config.rotationStrategyConfig());
        if (violation != null) {
            throw new BadRequestException(IndexSetDefaultsResource.buildFieldError("rotation_strategy_config", violation.message()));
        }
        violation = this.indexSetValidator.validateRetentionPeriod(config.rotationStrategyConfig(), config.retentionStrategyConfig());
        if (violation != null) {
            throw new BadRequestException(IndexSetDefaultsResource.buildFieldError("retention_strategy_config", violation.message()));
        }
        violation = this.indexSetValidator.validateDataTieringConfig(config.dataTiering());
        if (violation != null) {
            throw new BadRequestException(IndexSetDefaultsResource.buildFieldError("data_tiering", violation.message()));
        }
        config = config.toBuilder().useLegacyRotation(true).build();
        this.clusterConfigService.write(config);
        this.clusterConfigService.write(config);
        return Response.ok((Object)config).build();
    }
}

