/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetSummary;
import org.graylog2.validation.SizeInBytes;
import org.joda.time.Duration;

abstract class $AutoValue_IndexSetSummary
extends IndexSetSummary {
    @Nullable
    private final String id;
    @NotBlank
    private final String title;
    @Nullable
    private final String description;
    private final boolean isDefault;
    private final boolean canBeDefault;
    private final boolean isWritable;
    @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
    @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250)
    private final @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) String indexPrefix;
    @Min(value=1L)
    private final @Min(value=1L) int shards;
    @Min(value=0L)
    private final @Min(value=0L) int replicas;
    @Nullable
    private final String rotationStrategyClass;
    @Nullable
    private final RotationStrategyConfig rotationStrategy;
    @Nullable
    private final String retentionStrategyClass;
    @Nullable
    private final RetentionStrategyConfig retentionStrategy;
    @NotNull
    private final ZonedDateTime creationDate;
    @NotBlank
    private final String indexAnalyzer;
    @Min(value=1L)
    private final @Min(value=1L) int indexOptimizationMaxNumSegments;
    private final boolean indexOptimizationDisabled;
    private final Duration fieldTypeRefreshInterval;
    private final Optional<String> templateType;
    @Nullable
    private final String fieldTypeProfile;
    @Nullable
    private final DataTieringConfig dataTiering;
    @Nullable
    private final Boolean useLegacyRotation;

    $AutoValue_IndexSetSummary(@Nullable String id, @NotBlank String title, @Nullable String description, boolean isDefault, boolean canBeDefault, boolean isWritable, @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) String indexPrefix, @Min(value=1L) @Min(value=1L) int shards, @Min(value=0L) @Min(value=0L) int replicas, @Nullable String rotationStrategyClass, @Nullable RotationStrategyConfig rotationStrategy, @Nullable String retentionStrategyClass, @Nullable RetentionStrategyConfig retentionStrategy, @NotNull ZonedDateTime creationDate, @NotBlank String indexAnalyzer, @Min(value=1L) @Min(value=1L) int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled, Duration fieldTypeRefreshInterval, Optional<String> templateType, @Nullable String fieldTypeProfile, @Nullable DataTieringConfig dataTiering, @Nullable Boolean useLegacyRotation) {
        this.id = id;
        if (title == null) {
            throw new NullPointerException("Null title");
        }
        this.title = title;
        this.description = description;
        this.isDefault = isDefault;
        this.canBeDefault = canBeDefault;
        this.isWritable = isWritable;
        if (indexPrefix == null) {
            throw new NullPointerException("Null indexPrefix");
        }
        this.indexPrefix = indexPrefix;
        this.shards = shards;
        this.replicas = replicas;
        this.rotationStrategyClass = rotationStrategyClass;
        this.rotationStrategy = rotationStrategy;
        this.retentionStrategyClass = retentionStrategyClass;
        this.retentionStrategy = retentionStrategy;
        if (creationDate == null) {
            throw new NullPointerException("Null creationDate");
        }
        this.creationDate = creationDate;
        if (indexAnalyzer == null) {
            throw new NullPointerException("Null indexAnalyzer");
        }
        this.indexAnalyzer = indexAnalyzer;
        this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
        this.indexOptimizationDisabled = indexOptimizationDisabled;
        if (fieldTypeRefreshInterval == null) {
            throw new NullPointerException("Null fieldTypeRefreshInterval");
        }
        this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
        if (templateType == null) {
            throw new NullPointerException("Null templateType");
        }
        this.templateType = templateType;
        this.fieldTypeProfile = fieldTypeProfile;
        this.dataTiering = dataTiering;
        this.useLegacyRotation = useLegacyRotation;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="title")
    @NotBlank
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="default")
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    @JsonProperty(value="can_be_default")
    public boolean canBeDefault() {
        return this.canBeDefault;
    }

    @Override
    @JsonProperty(value="writable")
    public boolean isWritable() {
        return this.isWritable;
    }

    @Override
    @JsonProperty(value="index_prefix")
    @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
    @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250)
    public @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) String indexPrefix() {
        return this.indexPrefix;
    }

    @Override
    @JsonProperty(value="shards")
    @Min(value=1L)
    public @Min(value=1L) int shards() {
        return this.shards;
    }

    @Override
    @JsonProperty(value="replicas")
    @Min(value=0L)
    public @Min(value=0L) int replicas() {
        return this.replicas;
    }

    @Override
    @JsonProperty(value="rotation_strategy_class")
    @Nullable
    public String rotationStrategyClass() {
        return this.rotationStrategyClass;
    }

    @Override
    @JsonProperty(value="rotation_strategy")
    @Nullable
    public RotationStrategyConfig rotationStrategy() {
        return this.rotationStrategy;
    }

    @Override
    @JsonProperty(value="retention_strategy_class")
    @Nullable
    public String retentionStrategyClass() {
        return this.retentionStrategyClass;
    }

    @Override
    @JsonProperty(value="retention_strategy")
    @Nullable
    public RetentionStrategyConfig retentionStrategy() {
        return this.retentionStrategy;
    }

    @Override
    @JsonProperty(value="creation_date")
    @NotNull
    public ZonedDateTime creationDate() {
        return this.creationDate;
    }

    @Override
    @JsonProperty(value="index_analyzer")
    @NotBlank
    public String indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    @JsonProperty(value="index_optimization_max_num_segments")
    @Min(value=1L)
    public @Min(value=1L) int indexOptimizationMaxNumSegments() {
        return this.indexOptimizationMaxNumSegments;
    }

    @Override
    @JsonProperty(value="index_optimization_disabled")
    public boolean indexOptimizationDisabled() {
        return this.indexOptimizationDisabled;
    }

    @Override
    @JsonProperty(value="field_type_refresh_interval")
    public Duration fieldTypeRefreshInterval() {
        return this.fieldTypeRefreshInterval;
    }

    @Override
    @JsonProperty(value="index_template_type")
    public Optional<String> templateType() {
        return this.templateType;
    }

    @Override
    @JsonProperty(value="field_type_profile")
    @Nullable
    public String fieldTypeProfile() {
        return this.fieldTypeProfile;
    }

    @Override
    @JsonProperty(value="data_tiering")
    @Nullable
    public DataTieringConfig dataTiering() {
        return this.dataTiering;
    }

    @Override
    @JsonProperty(value="use_legacy_rotation")
    @Nullable
    public Boolean useLegacyRotation() {
        return this.useLegacyRotation;
    }

    public String toString() {
        return "IndexSetSummary{id=" + this.id + ", title=" + this.title + ", description=" + this.description + ", isDefault=" + this.isDefault + ", canBeDefault=" + this.canBeDefault + ", isWritable=" + this.isWritable + ", indexPrefix=" + this.indexPrefix + ", shards=" + this.shards + ", replicas=" + this.replicas + ", rotationStrategyClass=" + this.rotationStrategyClass + ", rotationStrategy=" + String.valueOf(this.rotationStrategy) + ", retentionStrategyClass=" + this.retentionStrategyClass + ", retentionStrategy=" + String.valueOf(this.retentionStrategy) + ", creationDate=" + String.valueOf(this.creationDate) + ", indexAnalyzer=" + this.indexAnalyzer + ", indexOptimizationMaxNumSegments=" + this.indexOptimizationMaxNumSegments + ", indexOptimizationDisabled=" + this.indexOptimizationDisabled + ", fieldTypeRefreshInterval=" + String.valueOf(this.fieldTypeRefreshInterval) + ", templateType=" + String.valueOf(this.templateType) + ", fieldTypeProfile=" + this.fieldTypeProfile + ", dataTiering=" + String.valueOf(this.dataTiering) + ", useLegacyRotation=" + this.useLegacyRotation + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexSetSummary) {
            IndexSetSummary that = (IndexSetSummary)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.title.equals(that.title()) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.isDefault == that.isDefault() && this.canBeDefault == that.canBeDefault() && this.isWritable == that.isWritable() && this.indexPrefix.equals(that.indexPrefix()) && this.shards == that.shards() && this.replicas == that.replicas() && (this.rotationStrategyClass == null ? that.rotationStrategyClass() == null : this.rotationStrategyClass.equals(that.rotationStrategyClass())) && (this.rotationStrategy == null ? that.rotationStrategy() == null : this.rotationStrategy.equals(that.rotationStrategy())) && (this.retentionStrategyClass == null ? that.retentionStrategyClass() == null : this.retentionStrategyClass.equals(that.retentionStrategyClass())) && (this.retentionStrategy == null ? that.retentionStrategy() == null : this.retentionStrategy.equals(that.retentionStrategy())) && this.creationDate.equals(that.creationDate()) && this.indexAnalyzer.equals(that.indexAnalyzer()) && this.indexOptimizationMaxNumSegments == that.indexOptimizationMaxNumSegments() && this.indexOptimizationDisabled == that.indexOptimizationDisabled() && this.fieldTypeRefreshInterval.equals((Object)that.fieldTypeRefreshInterval()) && this.templateType.equals(that.templateType()) && (this.fieldTypeProfile == null ? that.fieldTypeProfile() == null : this.fieldTypeProfile.equals(that.fieldTypeProfile())) && (this.dataTiering == null ? that.dataTiering() == null : this.dataTiering.equals(that.dataTiering())) && (this.useLegacyRotation == null ? that.useLegacyRotation() == null : this.useLegacyRotation.equals(that.useLegacyRotation()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.title.hashCode();
        h$ *= 1000003;
        h$ ^= this.description == null ? 0 : this.description.hashCode();
        h$ *= 1000003;
        h$ ^= this.isDefault ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.canBeDefault ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.isWritable ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.indexPrefix.hashCode();
        h$ *= 1000003;
        h$ ^= this.shards;
        h$ *= 1000003;
        h$ ^= this.replicas;
        h$ *= 1000003;
        h$ ^= this.rotationStrategyClass == null ? 0 : this.rotationStrategyClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.rotationStrategy == null ? 0 : this.rotationStrategy.hashCode();
        h$ *= 1000003;
        h$ ^= this.retentionStrategyClass == null ? 0 : this.retentionStrategyClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.retentionStrategy == null ? 0 : this.retentionStrategy.hashCode();
        h$ *= 1000003;
        h$ ^= this.creationDate.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexAnalyzer.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexOptimizationMaxNumSegments;
        h$ *= 1000003;
        h$ ^= this.indexOptimizationDisabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.fieldTypeRefreshInterval.hashCode();
        h$ *= 1000003;
        h$ ^= this.templateType.hashCode();
        h$ *= 1000003;
        h$ ^= this.fieldTypeProfile == null ? 0 : this.fieldTypeProfile.hashCode();
        h$ *= 1000003;
        h$ ^= this.dataTiering == null ? 0 : this.dataTiering.hashCode();
        h$ *= 1000003;
        return h$ ^= this.useLegacyRotation == null ? 0 : this.useLegacyRotation.hashCode();
    }
}

