/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.rest.models.tools.requests.ContainsStringTestRequest;
import org.graylog2.rest.models.tools.responses.ContainsStringTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/tools/contains_string_tester")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ContainsStringTesterResource
extends RestResource {
    @GET
    @Timed
    public ContainsStringTesterResponse containsStringTest(@QueryParam(value="string") @NotEmpty String string, @QueryParam(value="search_string") @NotEmpty String searchString) {
        return this.doTestContainsString(string, searchString);
    }

    @POST
    @Timed
    @NoAuditEvent(value="only used to test if field contains a string")
    public ContainsStringTesterResponse testContainsString(@Valid @NotNull ContainsStringTestRequest request) {
        return this.doTestContainsString(request.string(), request.searchString());
    }

    private ContainsStringTesterResponse doTestContainsString(String string, String searchString) {
        int index = string.indexOf(searchString);
        boolean contains = index != -1;
        ContainsStringTesterResponse.Match match = contains ? ContainsStringTesterResponse.Match.create(index, index + searchString.length()) : null;
        return ContainsStringTesterResponse.create(contains, match, searchString, string);
    }
}

