/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.inputs.extractors.SplitAndIndexExtractor;
import org.graylog2.rest.models.tools.requests.SplitAndIndexTestRequest;
import org.graylog2.rest.models.tools.responses.SplitAndIndexTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/tools/split_and_index_tester")
public class SplitAndIndexTesterResource
extends RestResource {
    @GET
    @Timed
    @Produces(value={"application/json"})
    public SplitAndIndexTesterResponse splitAndIndexTester(@QueryParam(value="split_by") @NotNull String splitBy, @QueryParam(value="index") @Min(value=0L) @Min(value=0L) int index, @QueryParam(value="string") @NotNull String string) {
        return this.doSplitAndIndexTest(string, splitBy, index);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoAuditEvent(value="only used to test split and index extractor")
    public SplitAndIndexTesterResponse splitAndIndexTest(@Valid @NotNull SplitAndIndexTestRequest splitAndIndexTestRequest) {
        return this.doSplitAndIndexTest(splitAndIndexTestRequest.string(), splitAndIndexTestRequest.splitBy(), splitAndIndexTestRequest.index());
    }

    private SplitAndIndexTesterResponse doSplitAndIndexTest(String string, String splitBy, int index) {
        String cut = SplitAndIndexExtractor.cut(string, splitBy, index - 1);
        int[] positions = SplitAndIndexExtractor.getCutIndices(string, splitBy, index - 1);
        return SplitAndIndexTesterResponse.create(cut != null, cut, positions[0], positions[1]);
    }
}

