/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.hash.Hashing;
import jakarta.inject.Inject;
import java.nio.charset.StandardCharsets;
import org.graylog2.Configuration;
import org.graylog2.security.AESTools;

public class AccessTokenCipher {
    private final byte[] encryptionKey;

    @Inject
    public AccessTokenCipher(Configuration configuration) {
        this.encryptionKey = Hashing.sha256().hashString((CharSequence)configuration.getPasswordSecret(), StandardCharsets.UTF_8).asBytes();
    }

    public String encrypt(String cleartext) {
        return AESTools.encryptSiv(cleartext, this.encryptionKey);
    }

    public String decrypt(String ciphertext) {
        return AESTools.decryptSiv(ciphertext, this.encryptionKey);
    }
}

