/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.debug;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import jakarta.inject.Inject;
import org.graylog2.system.debug.DebugEvent;
import org.graylog2.system.debug.DebugEventHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDebugEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDebugEventListener.class);

    @Inject
    public LocalDebugEventListener(EventBus serverEventBus) {
        ((EventBus)Preconditions.checkNotNull((Object)serverEventBus)).register((Object)this);
    }

    @Subscribe
    public void handleDebugEvent(DebugEvent event) {
        LOG.debug("Received local debug event: {}", (Object)event);
        DebugEventHolder.setLocalDebugEvent(event);
    }
}

