/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.contentpack.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.MutableGraph;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.events.contentpack.entities.AutoValue_EventDefinitionEntity;
import org.graylog.events.contentpack.entities.EventNotificationHandlerConfigEntity;
import org.graylog.events.contentpack.entities.EventProcessorConfigEntity;
import org.graylog.events.fields.EventFieldSpec;
import org.graylog.events.notifications.EventNotificationHandler;
import org.graylog.events.notifications.EventNotificationSettings;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.processor.EventProcessorConfig;
import org.graylog.events.processor.storage.EventStorageHandler;
import org.graylog2.contentpacks.NativeEntityConverter;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.ScopedContentPackEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.joda.time.DateTime;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EventDefinitionEntity
extends ScopedContentPackEntity
implements NativeEntityConverter<EventDefinitionDto> {
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_REMEDIATION_STEPS = "remediation_steps";
    private static final String FIELD_PRIORITY = "priority";
    private static final String FIELD_ALERT = "alert";
    private static final String FIELD_CONFIG = "config";
    private static final String FIELD_FIELD_SPEC = "field_spec";
    private static final String FIELD_KEY_SPEC = "key_spec";
    private static final String FIELD_NOTIFICATION_SETTINGS = "notification_settings";
    private static final String FIELD_NOTIFICATIONS = "notifications";
    private static final String FIELD_STORAGE = "storage";
    private static final String FIELD_IS_SCHEDULED = "is_scheduled";
    private static final String UPDATED_AT = "updated_at";
    private static final String MATCHED_AT = "matched_at";

    @JsonProperty(value="title")
    public abstract ValueReference title();

    @JsonProperty(value="description")
    public abstract ValueReference description();

    @Nullable
    @JsonProperty(value="remediation_steps")
    public abstract ValueReference remediationSteps();

    @Nullable
    @JsonProperty(value="updated_at")
    public abstract DateTime updatedAt();

    @Nullable
    @JsonProperty(value="matched_at")
    public abstract DateTime matchedAt();

    @JsonProperty(value="priority")
    public abstract ValueReference priority();

    @JsonProperty(value="alert")
    public abstract ValueReference alert();

    @JsonProperty(value="config")
    public abstract EventProcessorConfigEntity config();

    @JsonProperty(value="field_spec")
    public abstract ImmutableMap<String, EventFieldSpec> fieldSpec();

    @JsonProperty(value="key_spec")
    public abstract ImmutableList<String> keySpec();

    @JsonProperty(value="notification_settings")
    public abstract EventNotificationSettings notificationSettings();

    @JsonProperty(value="notifications")
    public abstract ImmutableList<EventNotificationHandlerConfigEntity> notifications();

    @JsonProperty(value="storage")
    public abstract ImmutableList<EventStorageHandler.Config> storage();

    @JsonProperty(value="is_scheduled")
    public abstract ValueReference isScheduled();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @Override
    public EventDefinitionDto toNativeEntity(Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        ImmutableList notificationList = ImmutableList.copyOf((Collection)this.notifications().stream().map(notification -> notification.toNativeEntity((Map)parameters, (Map)nativeEntities)).collect(Collectors.toList()));
        return ((EventDefinitionDto.Builder)EventDefinitionDto.builder().scope(this.scope() != null ? this.scope().asString(parameters) : "DEFAULT")).title(this.title().asString(parameters)).updatedAt(this.updatedAt()).description(this.description().asString(parameters)).remediationSteps(this.remediationSteps() != null ? this.remediationSteps().asString(parameters) : null).priority(this.priority().asInteger(parameters)).alert(this.alert().asBoolean(parameters)).config((EventProcessorConfig)this.config().toNativeEntity(parameters, nativeEntities)).fieldSpec(this.fieldSpec()).keySpec(this.keySpec()).notificationSettings(this.notificationSettings()).notifications((ImmutableList<EventNotificationHandler.Config>)notificationList).storage(this.storage()).build();
    }

    @Override
    public void resolveForInstallation(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities, MutableGraph<Entity> graph) {
        this.notifications().stream().map(EventNotificationHandlerConfigEntity::notificationId).map(valueReference -> valueReference.asString(parameters)).map(ModelId::of).map(modelId -> EntityDescriptor.create(modelId, ModelTypes.NOTIFICATION_V1)).map(entities::get).filter(Objects::nonNull).forEach(notification -> graph.putEdge((Object)entity, notification));
        this.config().resolveForInstallation(entity, parameters, entities, graph);
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends ScopedContentPackEntity.AbstractBuilder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_EventDefinitionEntity.Builder().isScheduled(ValueReference.of(true));
        }

        @JsonProperty(value="title")
        public abstract Builder title(ValueReference var1);

        @JsonProperty(value="description")
        public abstract Builder description(ValueReference var1);

        @JsonProperty(value="remediation_steps")
        public abstract Builder remediationSteps(ValueReference var1);

        @JsonProperty(value="updated_at")
        public abstract Builder updatedAt(DateTime var1);

        @JsonProperty(value="matched_at")
        public abstract Builder matchedAt(DateTime var1);

        @JsonProperty(value="priority")
        public abstract Builder priority(ValueReference var1);

        @JsonProperty(value="alert")
        public abstract Builder alert(ValueReference var1);

        @JsonProperty(value="config")
        public abstract Builder config(EventProcessorConfigEntity var1);

        @JsonProperty(value="field_spec")
        public abstract Builder fieldSpec(ImmutableMap<String, EventFieldSpec> var1);

        @JsonProperty(value="key_spec")
        public abstract Builder keySpec(ImmutableList<String> var1);

        @JsonProperty(value="notification_settings")
        public abstract Builder notificationSettings(EventNotificationSettings var1);

        @JsonProperty(value="notifications")
        public abstract Builder notifications(ImmutableList<EventNotificationHandlerConfigEntity> var1);

        @JsonProperty(value="storage")
        public abstract Builder storage(ImmutableList<EventStorageHandler.Config> var1);

        @JsonProperty(value="is_scheduled")
        public abstract Builder isScheduled(ValueReference var1);

        public abstract EventDefinitionEntity build();
    }
}

