/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.event;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.DateTimeDeserializer;
import java.io.IOException;
import java.util.Date;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public class ESMongoDateTimeDeserializer
extends StdScalarDeserializer<DateTime> {
    private static final JacksonJodaDateFormat ES_DATE_FORMAT = new JacksonJodaDateFormat(Tools.timeFormatterWithOptionalMilliseconds().withZone(DateTimeZone.UTC)).withAdjustToContextTZOverride(Boolean.valueOf(true));
    private static final JacksonJodaDateFormat ISO_DATE_FORMAT = new JacksonJodaDateFormat(ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.UTC)).withAdjustToContextTZOverride(Boolean.valueOf(true));
    private static final DateTimeDeserializer ES_DATE_DESERIALIZER = new DateTimeDeserializer(DateTime.class, ES_DATE_FORMAT);
    private static final DateTimeDeserializer ISO_DATE_DESERIALIZER = new DateTimeDeserializer(DateTime.class, ISO_DATE_FORMAT);

    public ESMongoDateTimeDeserializer() {
        super(DateTime.class);
    }

    public DateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object embeddedObject = p.getEmbeddedObject();
            if (embeddedObject instanceof Date) {
                Date date = (Date)embeddedObject;
                return new DateTime((Object)date, DateTimeZone.UTC);
            }
            throw new IllegalStateException("Unsupported token: " + String.valueOf(p.currentToken()));
        }
        try {
            return (DateTime)ISO_DATE_DESERIALIZER.deserialize(p, ctxt);
        }
        catch (IllegalArgumentException e) {
            return (DateTime)ES_DATE_DESERIALIZER.deserialize(p, ctxt);
        }
    }
}

