/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.fields;

import org.graylog.events.fields.FieldValue;
import org.graylog.events.fields.FieldValueType;

final class AutoValue_FieldValue
extends FieldValue {
    private final FieldValueType dataType;
    private final String value;

    private AutoValue_FieldValue(FieldValueType dataType, String value) {
        this.dataType = dataType;
        this.value = value;
    }

    @Override
    public FieldValueType dataType() {
        return this.dataType;
    }

    @Override
    public String value() {
        return this.value;
    }

    public String toString() {
        return "FieldValue{dataType=" + String.valueOf(this.dataType) + ", value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FieldValue) {
            FieldValue that = (FieldValue)o;
            return this.dataType.equals(that.dataType()) && this.value.equals(that.value());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.dataType.hashCode();
        h$ *= 1000003;
        return h$ ^= this.value.hashCode();
    }

    @Override
    public FieldValue.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends FieldValue.Builder {
        private FieldValueType dataType;
        private String value;

        Builder() {
        }

        private Builder(FieldValue source) {
            this.dataType = source.dataType();
            this.value = source.value();
        }

        @Override
        public FieldValue.Builder dataType(FieldValueType dataType) {
            if (dataType == null) {
                throw new NullPointerException("Null dataType");
            }
            this.dataType = dataType;
            return this;
        }

        @Override
        public FieldValue.Builder value(String value) {
            if (value == null) {
                throw new NullPointerException("Null value");
            }
            this.value = value;
            return this;
        }

        @Override
        public FieldValue build() {
            if (this.dataType == null || this.value == null) {
                StringBuilder missing = new StringBuilder();
                if (this.dataType == null) {
                    missing.append(" dataType");
                }
                if (this.value == null) {
                    missing.append(" value");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_FieldValue(this.dataType, this.value);
        }
    }
}

