/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.grn;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNDescriptor;
import org.graylog.grn.GRNDescriptorProvider;
import org.graylog.grn.GRNType;

public class GRNDescriptorService {
    private final Map<GRNType, GRNDescriptorProvider> descriptorProviders;

    @Inject
    public GRNDescriptorService(Map<GRNType, GRNDescriptorProvider> descriptorProviders) {
        this.descriptorProviders = descriptorProviders;
    }

    public GRNDescriptor getDescriptor(GRN grn) {
        GRNDescriptorProvider provider = this.descriptorProviders.get(grn.grnType());
        if (provider == null) {
            throw new IllegalStateException("Missing GRN descriptor provider for GRN type: " + grn.type());
        }
        return provider.get(grn);
    }

    public Set<GRNDescriptor> getDescriptors(Collection<GRN> grns) {
        return grns.stream().map(this::getDescriptor).collect(Collectors.toSet());
    }
}

