/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.aws;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.graylog.integrations.aws.codecs.KinesisCloudWatchFlowLogCodec;
import org.graylog.integrations.aws.codecs.KinesisRawLogCodec;
import org.graylog.integrations.aws.transports.KinesisTransport;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.transports.Transport;

public enum AWSMessageType {
    KINESIS_RAW(Source.KINESIS, "Kinesis Raw", "CloudWatchRawLog", KinesisRawLogCodec.Factory.class, "aws-kinesis-transport", KinesisTransport.Factory.class),
    KINESIS_CLOUDWATCH_RAW(Source.KINESIS, "Kinesis CloudWatch Raw", "CloudWatchRawLog", KinesisRawLogCodec.Factory.class, "aws-kinesis-transport", KinesisTransport.Factory.class),
    KINESIS_CLOUDWATCH_FLOW_LOGS(Source.KINESIS, "Kinesis CloudWatch Flow Log", "FlowLog", KinesisCloudWatchFlowLogCodec.Factory.class, "aws-kinesis-transport", KinesisTransport.Factory.class),
    UNKNOWN;

    private Source source;
    private String label;
    private String codecName;
    private Class<? extends Codec.Factory> codecFactory;
    private String transportName;
    private Class<? extends Transport.Factory> transportFactory;

    private AWSMessageType() {
    }

    private AWSMessageType(Source source, String label, String codecName, Class<? extends Codec.Factory> codecFactory, String transportName, Class<? extends Transport.Factory> transportFactory) {
        this.source = source;
        this.label = label;
        this.codecName = codecName;
        this.codecFactory = codecFactory;
        this.transportName = transportName;
        this.transportFactory = transportFactory;
    }

    public Class<? extends Codec.Factory> getCodecFactory() {
        return this.codecFactory;
    }

    public Class<? extends Transport.Factory> getTransportFactory() {
        return this.transportFactory;
    }

    public String getLabel() {
        return this.label;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public String getTransportName() {
        return this.transportName;
    }

    public boolean isKinesis() {
        return Source.KINESIS.equals((Object)this.source);
    }

    public static List<AWSMessageType> getMessageTypes() {
        return Arrays.stream(AWSMessageType.values()).filter(m -> !m.equals((Object)UNKNOWN)).collect(Collectors.toList());
    }

    public static enum Source {
        KINESIS;

    }
}

