/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.aws.resources;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.integrations.aws.resources.requests.AWSInputCreateRequest;
import org.graylog.integrations.aws.resources.requests.AWSRequestImpl;
import org.graylog.integrations.aws.resources.requests.KinesisHealthCheckRequest;
import org.graylog.integrations.aws.resources.responses.KinesisHealthCheckResponse;
import org.graylog.integrations.aws.resources.responses.LogGroupsResponse;
import org.graylog.integrations.aws.resources.responses.RegionsResponse;
import org.graylog.integrations.aws.resources.responses.StreamsResponse;
import org.graylog.integrations.aws.service.AWSService;
import org.graylog.integrations.aws.service.CloudWatchService;
import org.graylog.integrations.aws.service.KinesisService;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.inputs.Input;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.resources.system.inputs.AbstractInputsResource;
import org.graylog2.shared.inputs.MessageInputFactory;

@Api(value="AWS", description="AWS integrations")
@Path(value="/aws")
@RequiresAuthentication
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AWSResource
extends AbstractInputsResource
implements PluginRestResource {
    private final AWSService awsService;
    private final KinesisService kinesisService;
    private final CloudWatchService cloudWatchService;

    @Inject
    public AWSResource(AWSService awsService, KinesisService kinesisService, CloudWatchService cloudWatchService, MessageInputFactory messageInputFactory) {
        super(messageInputFactory.getAvailableInputs());
        this.awsService = awsService;
        this.kinesisService = kinesisService;
        this.cloudWatchService = cloudWatchService;
    }

    @GET
    @Timed
    @Path(value="/regions")
    @ApiOperation(value="Get all available AWS regions")
    @RequiresPermissions(value={"aws:read"})
    public RegionsResponse getAwsRegions() {
        return this.awsService.getAvailableRegions();
    }

    @POST
    @Timed
    @Path(value="/cloudwatch/log_groups")
    @ApiOperation(value="Get all available AWS CloudWatch log groups names for the specified region.")
    @RequiresPermissions(value={"aws:read"})
    @NoAuditEvent(value="This does not change any data")
    public LogGroupsResponse getLogGroupNames(@ApiParam(name="JSON body", required=true) @Valid @NotNull AWSRequestImpl request) {
        return this.cloudWatchService.getLogGroupNames(request);
    }

    @POST
    @Timed
    @Path(value="/kinesis/streams")
    @ApiOperation(value="Get all available Kinesis streams for the specified region.")
    @RequiresPermissions(value={"aws:read"})
    @NoAuditEvent(value="This does not change any data")
    public StreamsResponse getKinesisStreams(@ApiParam(name="JSON body", required=true) @Valid @NotNull AWSRequestImpl request) throws ExecutionException {
        return this.kinesisService.getKinesisStreamNames(request);
    }

    @POST
    @Timed
    @Path(value="/kinesis/health_check")
    @ApiOperation(value="Attempt to retrieve logs from the indicated AWS log group with the specified credentials.", response=KinesisHealthCheckResponse.class)
    @RequiresPermissions(value={"aws:read"})
    @NoAuditEvent(value="This does not change any data")
    public Response kinesisHealthCheck(@ApiParam(name="JSON body", required=true) @Valid @NotNull KinesisHealthCheckRequest heathCheckRequest) throws ExecutionException, IOException {
        KinesisHealthCheckResponse response = this.kinesisService.healthCheck(heathCheckRequest);
        return Response.accepted().entity((Object)response).build();
    }

    @POST
    @Timed
    @Path(value="/inputs")
    @ApiOperation(value="Create a new AWS input.")
    @RequiresPermissions(value={"inputs:create"})
    @AuditEvent(type="integrations:kinesis_input:create")
    public Response create(@ApiParam(name="JSON body", required=true) @Valid @NotNull AWSInputCreateRequest saveRequest) throws Exception {
        Input input = this.awsService.saveInput(saveRequest, this.getCurrentUser());
        return Response.ok().entity((Object)this.getInputSummary(input)).build();
    }
}

