/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.inputs.paloalto;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog.integrations.inputs.paloalto.PaloAltoFieldTemplate;
import org.graylog.integrations.inputs.paloalto.PaloAltoFieldType;
import org.graylog.integrations.inputs.paloalto.PaloAltoMessageTemplate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaloAltoTypeParser {
    private static final Logger LOG = LoggerFactory.getLogger(PaloAltoTypeParser.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm:ss ZZZ");
    private final PaloAltoMessageTemplate messageTemplate;

    public PaloAltoTypeParser(PaloAltoMessageTemplate messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public ImmutableMap<String, Object> parseFields(List<String> fields, DateTimeZone timezone) {
        HashMap fieldMap = Maps.newHashMap();
        ArrayList templateFields = Lists.newArrayList(this.messageTemplate.getFields());
        int fieldIndex = 0;
        int templateIndex = 0;
        while (fieldIndex < fields.size() && templateIndex < templateFields.size()) {
            String rawValue = fields.get(fieldIndex);
            PaloAltoFieldTemplate template = (PaloAltoFieldTemplate)templateFields.get(templateIndex);
            if (fieldIndex < template.position()) {
                ++fieldIndex;
                continue;
            }
            if (fieldIndex == template.position()) {
                List value = rawValue;
                if (template.fieldType() == PaloAltoFieldType.STRING) {
                    if (rawValue.startsWith("\"") && rawValue.endsWith("\"")) {
                        value = rawValue.substring(1, rawValue.length() - 1);
                    }
                } else if (template.fieldType() == PaloAltoFieldType.LONG) {
                    try {
                        value = Strings.isNullOrEmpty((String)rawValue) ? 0L : Long.valueOf(rawValue);
                    }
                    catch (NumberFormatException ex) {
                        LOG.error("Error parsing field {}, {} is not a valid numeric value", (Object)template.field(), (Object)rawValue);
                        value = null;
                    }
                } else if (template.fieldType() == PaloAltoFieldType.BOOLEAN) {
                    value = Boolean.valueOf(rawValue);
                } else if (template.fieldType() == PaloAltoFieldType.TIMESTAMP) {
                    String stringValue = rawValue;
                    if (rawValue.startsWith("\"") && rawValue.endsWith("\"")) {
                        stringValue = rawValue.substring(1, rawValue.length() - 1);
                    }
                    if (!Strings.isNullOrEmpty((String)stringValue)) {
                        try {
                            LOG.trace("Parsing timestamp {} with timezone {}", (Object)stringValue, (Object)timezone);
                            value = DateTime.parse((String)(stringValue + " " + String.valueOf(timezone)), (DateTimeFormatter)DATE_TIME_FORMATTER).withZone(timezone);
                            LOG.trace("Timestamp after parsing {}", (Object)value);
                        }
                        catch (Exception e) {
                            LOG.debug("Error parsing field {}, {} is not a valid timestamp value", new Object[]{template.field(), stringValue, e});
                        }
                    }
                } else {
                    LOG.warn("Unrecognized data type [{}] for field [{}], handling as STRING", (Object)template.fieldType(), (Object)template.field());
                }
                if (fieldMap.containsKey(template.field()) && !Strings.isNullOrEmpty((String)rawValue.trim()) && null != value && !((Object)value).equals(fieldMap.get(template.field()))) {
                    if (fieldMap.get(template.field()) instanceof List) {
                        valueList = (List)fieldMap.get(template.field());
                        valueList.add(value);
                        value = valueList;
                    } else {
                        valueList = Lists.newArrayList();
                        valueList.add(fieldMap.get(template.field()));
                        valueList.add(value);
                        value = valueList;
                    }
                }
                if (value != null) {
                    fieldMap.put(template.field(), value);
                }
                ++fieldIndex;
                ++templateIndex;
                continue;
            }
            LOG.error("Not sure the template fields are properly sorted");
            ++templateIndex;
        }
        return ImmutableMap.copyOf((Map)fieldMap);
    }
}

