/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.notifications.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.floreysoft.jmte.Engine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationException;
import org.graylog.events.notifications.EventNotificationModelData;
import org.graylog.events.notifications.EventNotificationService;
import org.graylog.events.notifications.PermanentEventNotificationException;
import org.graylog.events.notifications.TemporaryEventNotificationException;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.integrations.notifications.types.SlackClient;
import org.graylog.integrations.notifications.types.SlackEventNotificationConfig;
import org.graylog.integrations.notifications.types.SlackMessage;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.bindings.providers.ObjectMapperProvider;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackEventNotification
implements EventNotification {
    private static final Logger LOG = LoggerFactory.getLogger(SlackEventNotification.class);
    private final EventNotificationService notificationCallbackService;
    private final Engine templateEngine;
    private final NotificationService notificationService;
    private final ObjectMapperProvider objectMapperProvider;
    private final NodeId nodeId;
    private final SlackClient slackClient;
    private final URI httpExternalUri;

    @Inject
    public SlackEventNotification(EventNotificationService notificationCallbackService, ObjectMapperProvider objectMapperProvider, Engine templateEngine, NotificationService notificationService, NodeId nodeId, SlackClient slackClient, HttpConfiguration httpConfiguration) {
        this.notificationCallbackService = notificationCallbackService;
        this.objectMapperProvider = Objects.requireNonNull(objectMapperProvider);
        this.templateEngine = Objects.requireNonNull(templateEngine);
        this.notificationService = Objects.requireNonNull(notificationService);
        this.nodeId = Objects.requireNonNull(nodeId);
        this.slackClient = Objects.requireNonNull(slackClient);
        this.httpExternalUri = httpConfiguration.getHttpExternalUri();
    }

    @Override
    public void execute(EventNotificationContext ctx) throws EventNotificationException {
        SlackEventNotificationConfig config = (SlackEventNotificationConfig)ctx.notificationConfig();
        LOG.debug("SlackEventNotification backlog size in method execute is [{}]", (Object)config.backlogSize());
        try {
            SlackMessage slackMessage = this.createSlackMessage(ctx, config);
            this.slackClient.send(slackMessage, config.webhookUrl());
        }
        catch (JsonProcessingException ex) {
            String errorMessage = String.format(Locale.ENGLISH, "Error serializing Slack message object while sending the SlackEventNotification :: %s", ex.getMessage());
            LOG.error(errorMessage, (Throwable)ex);
            Notification systemNotification = this.notificationService.buildNow().addNode(this.nodeId.getNodeId()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.URGENT).addDetail("title", "SlackEventNotification Failed").addDetail("description", errorMessage);
            this.notificationService.publishIfFirst(systemNotification);
            throw new EventNotificationException("There was an error serializing the Slack message object when sending the SlackEventNotification", ex);
        }
        catch (TemporaryEventNotificationException exp) {
            throw exp;
        }
        catch (PermanentEventNotificationException exp) {
            String errorMessage = String.format(Locale.ENGLISH, "Error sending the SlackEventNotification :: %s", exp.getMessage());
            Notification systemNotification = this.notificationService.buildNow().addNode(this.nodeId.getNodeId()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.URGENT).addDetail("title", "SlackEventNotification Failed").addDetail("description", errorMessage);
            this.notificationService.publishIfFirst(systemNotification);
            throw exp;
        }
        catch (Exception exp) {
            throw new EventNotificationException("There was an exception triggering the SlackEventNotification", exp);
        }
    }

    SlackMessage createSlackMessage(EventNotificationContext ctx, SlackEventNotificationConfig config) throws PermanentEventNotificationException {
        String customMessage = null;
        String template = config.customMessage();
        if (!Strings.isNullOrEmpty((String)template)) {
            if (!config.includeTitle().booleanValue() && (config.notifyChannel() || config.notifyHere().booleanValue())) {
                String tag = config.notifyChannel() ? "channel" : "here";
                template = StringUtils.f("@%s\n%s", tag, template);
            }
            customMessage = this.buildCustomMessage(ctx, config, template);
        }
        SlackMessage.Attachment attachment = SlackMessage.Attachment.builder().color(config.color()).text(customMessage).build();
        boolean linkNames = config.linkNames() || config.notifyChannel() || config.notifyHere() != false;
        String templatedChannel = this.buildTemplatedChannel(ctx, config, config.channel());
        String emoji = config.iconEmoji() != null ? this.ensureEmojiSyntax(config.iconEmoji()) : "";
        return SlackMessage.builder().iconEmoji(emoji).iconUrl(config.iconUrl()).username(config.userName()).text(config.includeTitle() != false ? this.buildDefaultMessage(ctx, config) : null).channel(templatedChannel).linkNames(linkNames).attachments(Strings.isNullOrEmpty((String)template) ? Collections.emptySet() : Collections.singleton(attachment)).build();
    }

    private String ensureEmojiSyntax(String x) {
        Object emoji = x.trim();
        if (!((String)emoji).isEmpty() && !((String)emoji).startsWith(":")) {
            emoji = ":" + (String)emoji;
        }
        if (!((String)emoji).isEmpty() && !((String)emoji).endsWith(":")) {
            emoji = (String)emoji + ":";
        }
        return emoji;
    }

    String buildDefaultMessage(EventNotificationContext ctx, SlackEventNotificationConfig config) {
        String title = this.buildMessageTitle(ctx);
        String audience = "";
        if (config.notifyChannel() || config.notifyHere().booleanValue()) {
            audience = config.notifyChannel() ? "@channel " : "@here ";
        }
        String description = ctx.eventDefinition().map(EventDefinitionDto::description).orElse("");
        return String.format(Locale.ROOT, "%s*Alert %s* triggered:\n> %s \n", audience, title, description);
    }

    private String buildMessageTitle(EventNotificationContext ctx) {
        String eventDefinitionName = ctx.eventDefinition().map(EventDefinitionDto::title).orElse("Unnamed");
        return "_" + eventDefinitionName + "_";
    }

    String buildTemplatedChannel(EventNotificationContext ctx, SlackEventNotificationConfig config, String template) throws PermanentEventNotificationException {
        List<MessageSummary> backlog = this.getMessageBacklog(ctx, config);
        Map<String, Object> model = this.getCustomMessageModel(ctx, config.type(), backlog, config.timeZone());
        try {
            LOG.debug("channel: template = {} model = {}", (Object)template, model);
            return this.templateEngine.transform(template, model);
        }
        catch (Exception e) {
            String error = "Invalid channel template.";
            LOG.error(error + "[{}]", (Object)e.toString());
            throw new PermanentEventNotificationException(error + String.valueOf(e), e.getCause());
        }
    }

    String buildCustomMessage(EventNotificationContext ctx, SlackEventNotificationConfig config, String template) throws PermanentEventNotificationException {
        List<MessageSummary> backlog = this.getMessageBacklog(ctx, config);
        Map<String, Object> model = this.getCustomMessageModel(ctx, config.type(), backlog, config.timeZone());
        try {
            LOG.debug("customMessage: template = {} model = {}", (Object)template, model);
            return this.templateEngine.transform(template, model);
        }
        catch (Exception e) {
            String error = "Invalid Custom Message template.";
            LOG.error(error + "[{}]", (Object)e.toString());
            throw new PermanentEventNotificationException(error + String.valueOf(e), e.getCause());
        }
    }

    @VisibleForTesting
    List<MessageSummary> getMessageBacklog(EventNotificationContext ctx, SlackEventNotificationConfig config) {
        ImmutableList<MessageSummary> backlog = this.notificationCallbackService.getBacklogForEvent(ctx);
        if (config.backlogSize() > 0L && backlog != null) {
            return backlog.stream().limit(config.backlogSize()).collect(Collectors.toList());
        }
        return backlog;
    }

    @VisibleForTesting
    Map<String, Object> getCustomMessageModel(EventNotificationContext ctx, String type, List<MessageSummary> backlog, DateTimeZone timeZone) {
        EventNotificationModelData modelData = EventNotificationModelData.of(ctx, backlog);
        LOG.debug("the custom message model data is {}", (Object)modelData.toString());
        Map objectMap = (Map)this.objectMapperProvider.getForTimeZone(timeZone).convertValue((Object)modelData, TypeReferences.MAP_STRING_OBJECT);
        objectMap.put("type", type);
        objectMap.put("http_external_uri", this.httpExternalUri);
        return objectMap;
    }

    public static interface Factory
    extends EventNotification.Factory {
        public SlackEventNotification create();
    }
}

