/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.notifications.types.microsoftteams;

import com.floreysoft.jmte.Engine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationException;
import org.graylog.events.notifications.EventNotificationModelData;
import org.graylog.events.notifications.EventNotificationService;
import org.graylog.events.notifications.PermanentEventNotificationException;
import org.graylog.events.notifications.TemporaryEventNotificationException;
import org.graylog.integrations.notifications.types.microsoftteams.TeamsEventNotificationConfigV2;
import org.graylog.integrations.notifications.types.util.RequestClient;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.bindings.providers.ObjectMapperProvider;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamsEventNotificationV2
implements EventNotification {
    private static final Logger LOG = LoggerFactory.getLogger(TeamsEventNotificationV2.class);
    private final EventNotificationService notificationCallbackService;
    private final Engine jsonTemplateEngine;
    private final NotificationService notificationService;
    private final ObjectMapperProvider objectMapperProvider;
    private final NodeId nodeId;
    private final RequestClient requestClient;
    private final URI httpExternalUri;

    @Inject
    public TeamsEventNotificationV2(EventNotificationService notificationCallbackService, ObjectMapperProvider objectMapperProvider, @Named(value="JsonSafe") Engine jsonTemplateEngine, NotificationService notificationService, NodeId nodeId, RequestClient requestClient, HttpConfiguration httpConfiguration) {
        this.notificationCallbackService = notificationCallbackService;
        this.objectMapperProvider = Objects.requireNonNull(objectMapperProvider);
        this.jsonTemplateEngine = Objects.requireNonNull(jsonTemplateEngine);
        this.notificationService = Objects.requireNonNull(notificationService);
        this.nodeId = Objects.requireNonNull(nodeId);
        this.requestClient = Objects.requireNonNull(requestClient);
        this.httpExternalUri = httpConfiguration.getHttpExternalUri();
    }

    @Override
    public void execute(EventNotificationContext ctx) throws EventNotificationException {
        TeamsEventNotificationConfigV2 config = (TeamsEventNotificationConfigV2)ctx.notificationConfig();
        LOG.debug("TeamsEventNotificationV2 backlog size in method execute is [{}]", (Object)config.backlogSize());
        try {
            String requestBody = this.generateBody(ctx, config);
            this.requestClient.send(requestBody, config.webhookUrl());
        }
        catch (TemporaryEventNotificationException exp) {
            throw exp;
        }
        catch (PermanentEventNotificationException exp) {
            String errorMessage = StringUtils.f("Error sending Teams Notification ID: %s. %s", ctx.notificationId(), exp.getMessage());
            Notification systemNotification = this.notificationService.buildNow().addNode(this.nodeId.getNodeId()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.URGENT).addDetail("title", "TeamsEventNotificationV2 Failed").addDetail("description", errorMessage);
            this.notificationService.publishIfFirst(systemNotification);
            throw exp;
        }
        catch (Exception exp) {
            throw new EventNotificationException("There was an exception triggering the TeamsEventNotification", exp);
        }
    }

    @VisibleForTesting
    String generateBody(EventNotificationContext ctx, TeamsEventNotificationConfigV2 config) throws PermanentEventNotificationException {
        List<MessageSummary> backlog = this.getMessageBacklog(ctx, config);
        Map<String, Object> model = this.getCustomMessageModel(ctx, config.type(), backlog, config.timeZone());
        try {
            return this.jsonTemplateEngine.transform(config.adaptiveCard(), model);
        }
        catch (Exception e) {
            String error = "Invalid Custom Message template.";
            LOG.error("{} [{}]", (Object)error, (Object)e.toString());
            throw new PermanentEventNotificationException(error + String.valueOf(e), e.getCause());
        }
    }

    @VisibleForTesting
    List<MessageSummary> getMessageBacklog(EventNotificationContext ctx, TeamsEventNotificationConfigV2 config) {
        ImmutableList<MessageSummary> backlog = this.notificationCallbackService.getBacklogForEvent(ctx);
        if (config.backlogSize() > 0L && backlog != null) {
            return backlog.stream().limit(config.backlogSize()).collect(Collectors.toList());
        }
        return backlog;
    }

    @VisibleForTesting
    Map<String, Object> getCustomMessageModel(EventNotificationContext ctx, String type, List<MessageSummary> backlog, DateTimeZone timeZone) {
        EventNotificationModelData modelData = EventNotificationModelData.of(ctx, backlog);
        LOG.debug("Custom message model: {}", (Object)modelData);
        Map objectMap = (Map)this.objectMapperProvider.getForTimeZone(timeZone).convertValue((Object)modelData, TypeReferences.MAP_STRING_OBJECT);
        objectMap.put("type", type);
        objectMap.put("http_external_uri", this.httpExternalUri);
        return objectMap;
    }

    public static interface Factory
    extends EventNotification.Factory<TeamsEventNotificationV2> {
        @Override
        public TeamsEventNotificationV2 create();
    }
}

