/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BinaryExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.LogicalExpression;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ComparisonExpression
extends BinaryExpression
implements LogicalExpression {
    private final String operator;

    public ComparisonExpression(Token start, Expression left, Expression right, String operator) {
        super(start, left, right);
        this.operator = operator;
    }

    @Override
    public Object evaluateUnsafe(EvaluationContext context) {
        return this.evaluateBool(context);
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public boolean evaluateBool(EvaluationContext context) {
        Object leftValue = this.left.evaluateUnsafe(context);
        Object rightValue = this.right.evaluateUnsafe(context);
        if (leftValue instanceof DateTime && rightValue instanceof DateTime) {
            return this.compareDateTimes(this.operator, (DateTime)leftValue, (DateTime)rightValue);
        }
        if (leftValue instanceof Double || rightValue instanceof Double) {
            return this.compareDouble(this.operator, (Double)leftValue, (Double)rightValue);
        }
        return this.compareLong(this.operator, (Long)leftValue, (Long)rightValue);
    }

    private boolean compareLong(String operator, long left, long right) {
        switch (operator) {
            case ">": {
                return left > right;
            }
            case ">=": {
                return left >= right;
            }
            case "<": {
                return left < right;
            }
            case "<=": {
                return left <= right;
            }
        }
        return false;
    }

    private boolean compareDouble(String operator, double left, double right) {
        switch (operator) {
            case ">": {
                return left > right;
            }
            case ">=": {
                return left >= right;
            }
            case "<": {
                return left < right;
            }
            case "<=": {
                return left <= right;
            }
        }
        return false;
    }

    private boolean compareDateTimes(String operator, DateTime left, DateTime right) {
        switch (operator) {
            case ">": {
                return left.isAfter((ReadableInstant)right);
            }
            case ">=": {
                return !left.isBefore((ReadableInstant)right);
            }
            case "<": {
                return left.isBefore((ReadableInstant)right);
            }
            case "<=": {
                return !left.isAfter((ReadableInstant)right);
            }
        }
        return false;
    }

    public String getOperator() {
        return this.operator;
    }

    public String toString() {
        return this.left.toString() + " " + this.operator + " " + this.right.toString();
    }
}

