/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BaseExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;

public class IndexedAccessExpression
extends BaseExpression {
    private final Expression indexableObject;
    private final Expression index;

    public IndexedAccessExpression(Token start, Expression indexableObject, Expression index) {
        super(start);
        this.indexableObject = indexableObject;
        this.index = index;
    }

    @Override
    public boolean isConstant() {
        return this.indexableObject.isConstant() && this.index.isConstant();
    }

    @Override
    public Object evaluateUnsafe(EvaluationContext context) {
        Object idxObj = this.index.evaluateUnsafe(context);
        Object indexable = this.indexableObject.evaluateUnsafe(context);
        if (idxObj == null || indexable == null) {
            return null;
        }
        if (idxObj instanceof Long) {
            int idx = Ints.saturatedCast((long)((Long)idxObj));
            if (indexable.getClass().isArray()) {
                return Array.get(indexable, idx);
            }
            if (indexable instanceof List) {
                return ((List)indexable).get(idx);
            }
            if (indexable instanceof Iterable) {
                return Iterables.get((Iterable)((Iterable)indexable), (int)idx);
            }
            throw new IllegalArgumentException(context.pipelineErrorMessage("Object '" + String.valueOf(indexable) + "' is not an Array, List or Iterable."));
        }
        if (idxObj instanceof String) {
            String idx = idxObj.toString();
            if (indexable instanceof Map) {
                return ((Map)indexable).get(idx);
            }
            throw new IllegalArgumentException(context.pipelineErrorMessage("Object '" + String.valueOf(indexable) + "' is not a Map."));
        }
        throw new IllegalArgumentException(context.pipelineErrorMessage("Index '" + String.valueOf(idxObj) + "' is not a Long or String."));
    }

    @Override
    public Class getType() {
        return Object.class;
    }

    public String toString() {
        return this.indexableObject.toString() + "[" + this.index.toString() + "]";
    }

    public Expression getIndexableObject() {
        return this.indexableObject;
    }

    public Expression getIndex() {
        return this.index;
    }

    @Override
    public Iterable<Expression> children() {
        return ImmutableList.of((Object)this.indexableObject, (Object)this.index);
    }
}

