/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.memory;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.graylog.plugins.pipelineprocessor.db.PipelineStreamConnectionsService;
import org.graylog.plugins.pipelineprocessor.events.PipelineConnectionsChangedEvent;
import org.graylog.plugins.pipelineprocessor.rest.PipelineConnections;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;

public class InMemoryPipelineStreamConnectionsService
implements PipelineStreamConnectionsService {
    private final AtomicLong idGen = new AtomicLong(0L);
    private final Map<String, PipelineConnections> store = new ConcurrentHashMap<String, PipelineConnections>();
    private final ClusterEventBus clusterBus;

    @Inject
    public InMemoryPipelineStreamConnectionsService(ClusterEventBus clusterBus) {
        this.clusterBus = clusterBus;
    }

    @Override
    public PipelineConnections save(PipelineConnections connections) {
        PipelineConnections toSave = connections.id() != null ? connections : connections.toBuilder().id(this.createId()).build();
        this.store.put(toSave.id(), toSave);
        this.clusterBus.post(PipelineConnectionsChangedEvent.create(toSave.streamId(), toSave.pipelineIds()));
        return toSave;
    }

    @Override
    public PipelineConnections load(String streamId) throws NotFoundException {
        PipelineConnections connections = this.store.get(streamId);
        if (connections == null) {
            throw new NotFoundException("No such pipeline connections for stream " + streamId);
        }
        return connections;
    }

    @Override
    public Set<PipelineConnections> loadAll() {
        return ImmutableSet.copyOf(this.store.values());
    }

    @Override
    public Set<PipelineConnections> loadByPipelineId(String pipelineId) {
        return this.store.values().stream().filter(connection -> connection.pipelineIds().contains(pipelineId)).collect(Collectors.toSet());
    }

    @Override
    public void delete(String streamId) {
        try {
            PipelineConnections connections = this.load(streamId);
            Set<String> pipelineIds = connections.pipelineIds();
            this.store.remove(connections.id());
            this.clusterBus.post(PipelineConnectionsChangedEvent.create(streamId, pipelineIds));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private String createId() {
        return String.valueOf(this.idGen.incrementAndGet());
    }
}

