/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.conversion;

import com.google.common.collect.ImmutableList;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class BooleanConversion
extends AbstractFunction<Boolean> {
    public static final String NAME = "to_bool";
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").ruleBuilderVariable().description("Value to convert").build();
    private final ParameterDescriptor<Boolean, Boolean> defaultParam = ParameterDescriptor.bool("default").optional().description("Used when 'value' is null, defaults to false").build();

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        Object value = this.valueParam.required(args, context);
        if (value == null) {
            return this.defaultParam.optional(args, context).orElse(false);
        }
        return Boolean.parseBoolean(String.valueOf(value));
    }

    @Override
    public FunctionDescriptor<Boolean> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Boolean.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.defaultParam)).description("Converts a value to a boolean value using its string representation").ruleBuilderEnabled().ruleBuilderName("Convert to boolean").ruleBuilderTitle("Convert '${value}' to boolean").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.CONVERSION).build();
    }
}

