/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.db;

import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragmentService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;

@Singleton
public class MongoDBRuleFragmentService
implements RuleFragmentService {
    private static final RateLimitedLog log = PipelineInterpreter.getRateLimitedLog(MongoDBRuleFragmentService.class);
    public static final String COLLECTION_NAME = "rule_fragments";
    private final JacksonDBCollection<RuleFragment, ObjectId> dbCollection;

    @Inject
    public MongoDBRuleFragmentService(MongoJackObjectMapperProvider objectMapperProvider, MongoConnection mongoConnection) {
        this(JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection(COLLECTION_NAME), RuleFragment.class, ObjectId.class, objectMapperProvider.get()));
    }

    public MongoDBRuleFragmentService(JacksonDBCollection<RuleFragment, ObjectId> dbCollection) {
        this.dbCollection = Objects.requireNonNull(dbCollection);
        this.dbCollection.createIndex((DBObject)new BasicDBObject("name", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public RuleFragment save(RuleFragment ruleFragment) {
        return this.dbCollection.save(ruleFragment).getSavedObject();
    }

    @Override
    public void delete(String name) {
        this.dbCollection.remove((Bson)DBQuery.is((String)"name", (Object)name));
    }

    @Override
    public void deleteAll() {
        this.dbCollection.remove((Bson)DBQuery.empty());
    }

    @Override
    public long count(String name) {
        return this.dbCollection.getCount((Bson)DBQuery.is((String)"name", (Object)name));
    }

    @Override
    public Optional<RuleFragment> get(String name) {
        return Optional.ofNullable(this.dbCollection.findOne((Bson)DBQuery.is((String)"name", (Object)name)));
    }

    @Override
    public Collection<RuleFragment> all() {
        DBCursor<RuleFragment> ruleDaos = this.dbCollection.find().sort((Bson)DBSort.asc((String)"title"));
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(ruleDaos);
            if (ruleDaos != null) {
                ruleDaos.close();
            }
            return immutableSet;
        }
        catch (Throwable throwable) {
            try {
                if (ruleDaos != null) {
                    try {
                        ruleDaos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MongoException e) {
                log.error("Unable to load rule fragments", (Throwable)e);
                return Collections.emptySet();
            }
        }
    }
}

