/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.parser;

import freemarker.template.Configuration;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderRegistry;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderStep;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.ParserUtil;
import org.graylog2.bindings.providers.SecureFreemarkerConfigProvider;

@Singleton
public class ActionParser {
    public static final String NL = System.lineSeparator();
    protected final Map<String, RuleFragment> actions;
    private final Configuration freemarkerConfiguration;

    @Inject
    public ActionParser(RuleBuilderRegistry ruleBuilderRegistry, SecureFreemarkerConfigProvider secureFreemarkerConfigProvider) {
        this.actions = ruleBuilderRegistry.actions();
        this.freemarkerConfiguration = ParserUtil.initializeFragmentTemplates(secureFreemarkerConfigProvider, this.actions);
    }

    public Map<String, RuleFragment> getActions() {
        return this.actions;
    }

    public String generate(List<RuleBuilderStep> actions, boolean generateSimulatorFields) {
        AtomicInteger index = new AtomicInteger(1);
        return actions.stream().map(s -> this.generateAction((RuleBuilderStep)s, generateSimulatorFields, index.getAndIncrement())).collect(Collectors.joining(NL));
    }

    String generateAction(RuleBuilderStep step, boolean generateSimulatorFields, int index) {
        RuleFragment ruleFragment = this.actions.get(step.function());
        if (Objects.isNull(ruleFragment)) {
            return "";
        }
        FunctionDescriptor function = ruleFragment.descriptor();
        Object syntax = "  ";
        if (Objects.nonNull(step.outputvariable()) && ruleFragment.isFunction()) {
            syntax = (String)syntax + "let " + step.outputvariable() + " = ";
        }
        if (step.negate() && ruleFragment.isFunction()) {
            syntax = (String)syntax + "! ";
        }
        syntax = ruleFragment.isFragment() ? (String)syntax + ParserUtil.generateForFragment(step, this.freemarkerConfiguration) : (String)syntax + ParserUtil.generateForFunction(step, function) + ";";
        if (ruleFragment.isFragment() && Objects.nonNull(ruleFragment.fragmentOutputVariable()) && Objects.nonNull(step.outputvariable())) {
            syntax = (String)syntax + NL + "  let " + step.outputvariable() + " = " + (ruleFragment.isFragment() && step.negate() ? "! " : "") + ruleFragment.fragmentOutputVariable() + ";";
        }
        if (generateSimulatorFields && Objects.nonNull(step.outputvariable())) {
            syntax = (String)syntax + NL;
            syntax = (String)syntax + "  set_field(\"gl2_simulator_step_" + index + "_" + step.outputvariable() + "\", " + this.cloneVarIfNecessary(step.outputvariable(), function.returnType()) + ");";
        }
        return syntax;
    }

    private String cloneVarIfNecessary(String outputvariable, Class<?> returnType) {
        if (returnType == Map.class) {
            return "map_copy(" + outputvariable + ")";
        }
        return outputvariable;
    }
}

