/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.whois.ip;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.whois.WhoisClient;
import org.graylog.plugins.threatintel.whois.ip.InternetRegistry;
import org.graylog.plugins.threatintel.whois.ip.WhoisDataAdapter;
import org.graylog.plugins.threatintel.whois.ip.WhoisIpLookupResult;
import org.graylog.plugins.threatintel.whois.ip.WhoisLookupException;
import org.graylog.plugins.threatintel.whois.ip.parsers.AFRINICResponseParser;
import org.graylog.plugins.threatintel.whois.ip.parsers.APNICResponseParser;
import org.graylog.plugins.threatintel.whois.ip.parsers.ARINResponseParser;
import org.graylog.plugins.threatintel.whois.ip.parsers.LACNICResponseParser;
import org.graylog.plugins.threatintel.whois.ip.parsers.RIPENCCResponseParser;
import org.graylog.plugins.threatintel.whois.ip.parsers.WhoisParser;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhoisIpLookup {
    protected static final Logger LOG = LoggerFactory.getLogger(WhoisIpLookup.class);
    private static final int PORT = 43;
    private final InternetRegistry defaultRegistry;
    private final int connectTimeout;
    private final int readTimeout;
    private final Timer whoisRequestTimer;

    public WhoisIpLookup(WhoisDataAdapter.Config whoisConfig, MetricRegistry metricRegistry) {
        this.defaultRegistry = whoisConfig.registry();
        this.connectTimeout = whoisConfig.connectTimeout();
        this.readTimeout = whoisConfig.readTimeout();
        this.whoisRequestTimer = metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"whoisRequestTime"}));
    }

    public WhoisIpLookupResult run(String ip) throws Exception {
        try {
            return this.run(this.defaultRegistry, ip);
        }
        catch (WhoisLookupException e) {
            WhoisLookupException rootCause = (WhoisLookupException)e.getCause();
            InternetRegistry rootCauseRegistry = rootCause.getRegistry();
            String error = StringUtils.f("Could not lookup WHOIS information for [%s] at [%s].", new Object[]{ip, rootCauseRegistry});
            WhoisLookupException whoisLookupException = new WhoisLookupException(error, e.getCause(), rootCauseRegistry);
            if (!LOG.isTraceEnabled()) {
                LOG.error(error);
            } else {
                LOG.error(error, (Throwable)whoisLookupException);
            }
            throw whoisLookupException;
        }
    }

    public WhoisIpLookupResult run(InternetRegistry registry, String ip) throws Exception {
        WhoisParser parser = switch (registry) {
            case InternetRegistry.AFRINIC -> new AFRINICResponseParser();
            case InternetRegistry.APNIC -> new APNICResponseParser();
            case InternetRegistry.ARIN -> new ARINResponseParser();
            case InternetRegistry.LACNIC -> new LACNICResponseParser();
            case InternetRegistry.RIPENCC -> new RIPENCCResponseParser();
            default -> throw new RuntimeException("No parser implemented for [" + registry.name() + "] responses. This is a bug.");
        };
        WhoisClient whoisClient = new WhoisClient();
        try {
            WhoisIpLookupResult whoisIpLookupResult;
            whoisClient.setDefaultPort(43);
            whoisClient.setConnectTimeout(this.connectTimeout);
            whoisClient.setDefaultTimeout(this.readTimeout);
            String query = parser.buildQueryForIp(ip);
            try (Timer.Context ignored = this.whoisRequestTimer.time();){
                whoisClient.connect(registry.getWhoisServer());
                IOUtils.readLines((InputStream)whoisClient.getInputStream(query), (Charset)StandardCharsets.UTF_8).forEach(parser::readLine);
            }
            whoisClient.disconnect();
            if (parser.isRedirect()) {
                if (registry.equals((Object)parser.getRegistryRedirect())) {
                    LOG.error("{} redirected us back to itself. The Elders of the Internet say: This cannot happen(tm).", (Object)registry.toString());
                    whoisIpLookupResult = null;
                    return whoisIpLookupResult;
                }
                whoisIpLookupResult = this.run(parser.getRegistryRedirect(), ip);
                return whoisIpLookupResult;
            }
            whoisIpLookupResult = new WhoisIpLookupResult(parser.getOrganization(), parser.getCountryCode());
            return whoisIpLookupResult;
        }
        catch (Exception e) {
            throw new WhoisLookupException(e, registry);
        }
        finally {
            if (whoisClient.isConnected()) {
                whoisClient.disconnect();
            }
        }
    }
}

