/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.ValueParameter;
import org.graylog2.contentpacks.ContentPackable;
import org.graylog2.contentpacks.EntityDescriptorIds;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=ValueParameter.class)
public interface Parameter
extends ContentPackable<Parameter> {
    public static final String TYPE_FIELD = "type";

    @JsonProperty(value="type")
    public String type();

    @JsonProperty
    public String name();

    @Nullable
    @JsonProperty
    public String title();

    @Nullable
    @JsonProperty
    public String description();

    @JsonProperty(value="data_type")
    public String dataType();

    @Nullable
    @JsonProperty(value="default_value")
    public Object defaultValue();

    @JsonProperty
    public boolean optional();

    @Nullable
    @JsonProperty
    public Binding binding();

    public Parameter applyBindings(Map<String, Binding> var1);

    @Override
    default public Parameter toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return this;
    }

    public static interface BindingHandler<B extends Binding, P extends Parameter> {
        default public Object resolve(Binding binding, Parameter parameter) {
            return this.doResolve(binding, parameter);
        }

        public Object doResolve(B var1, P var2);
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=Fallback.class)
    public static interface Binding {
        public static final String TYPE_FIELD = "type";

        @JsonProperty(value="type")
        public String type();

        public static class Fallback
        implements Binding {
            @JsonProperty
            private String type;
            private Map<String, Object> props = Maps.newHashMap();

            @Override
            public String type() {
                return this.type;
            }

            @JsonAnySetter
            public void setProperties(String key, Object value) {
                this.props.put(key, value);
            }

            @JsonAnyGetter
            public Map<String, Object> getProperties() {
                return this.props;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Fallback fallback = (Fallback)o;
                return Objects.equals(this.type, fallback.type) && Objects.equals(this.props, fallback.props);
            }

            public int hashCode() {
                return Objects.hash(this.type, this.props);
            }
        }
    }

    public static interface Factory<TYPE extends Parameter> {
        public TYPE create(Parameter var1);
    }

    public static interface Builder<SELF> {
        @JsonProperty(value="type")
        public SELF type(String var1);

        @JsonProperty
        public SELF name(String var1);

        @JsonProperty
        public SELF title(String var1);

        @JsonProperty
        public SELF description(String var1);

        @JsonProperty(value="data_type")
        public SELF dataType(String var1);

        @JsonProperty(value="default_value")
        public SELF defaultValue(Object var1);

        @JsonProperty
        public SELF optional(boolean var1);

        @JsonProperty
        public SELF binding(Binding var1);
    }
}

