/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.AutoValue_QueryResult;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.QueryExecutionStats;
import org.graylog.plugins.views.search.errors.SearchError;

@JsonAutoDetect
@JsonDeserialize(builder=AutoValue_QueryResult.Builder.class)
@AutoValue
public abstract class QueryResult {
    public static QueryResult incomplete() {
        return QueryResult.emptyResult().toBuilder().state(State.INCOMPLETE).build();
    }

    @JsonProperty
    public abstract Query query();

    @JsonProperty(value="execution_stats")
    public abstract QueryExecutionStats executionStats();

    @JsonProperty(value="search_types")
    public abstract Map<String, SearchType.Result> searchTypes();

    @JsonProperty(value="errors")
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Set<SearchError> errors();

    @JsonProperty(value="state")
    public abstract State state();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    public static QueryResult emptyResult() {
        return QueryResult.builder().searchTypes(Collections.emptyMap()).query(Query.emptyRoot()).build();
    }

    public static QueryResult failedQueryWithError(Query query, SearchError error) {
        return QueryResult.emptyResult().toBuilder().query(query).errors(Collections.singleton(error)).state(State.FAILED).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_QueryResult.Builder().state(State.COMPLETED).executionStats(QueryExecutionStats.empty());
        }

        @JsonProperty
        public abstract Builder query(Query var1);

        @JsonProperty(value="execution_stats")
        public abstract Builder executionStats(QueryExecutionStats var1);

        @JsonProperty(value="search_types")
        public abstract Builder searchTypes(Map<String, SearchType.Result> var1);

        @JsonProperty(value="errors")
        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public abstract Builder errors(@Nullable Set<SearchError> var1);

        @JsonProperty(value="state")
        public abstract Builder state(State var1);

        public abstract QueryResult build();
    }

    public static enum State {
        INCOMPLETE,
        FAILED,
        COMPLETED;

    }
}

