/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.engine.QueryFragment;
import org.graylog.plugins.views.search.engine.QueryPosition;

public class PositionTrackingQuery {
    private final List<QueryFragment> fragments;

    public PositionTrackingQuery(List<QueryFragment> fragments) {
        this.fragments = fragments;
    }

    public static PositionTrackingQuery of(String queryString) {
        return new PositionTrackingQuery(Collections.singletonList(new QueryFragment(queryString, queryString, 1, 0, queryString.length())));
    }

    public List<QueryFragment> getFragments() {
        return this.fragments;
    }

    public String getOriginalQuery() {
        return this.concatFragments(QueryFragment::getOriginalContent);
    }

    public String getInterpolatedQuery() {
        return this.concatFragments(QueryFragment::getInterpolatedContent);
    }

    private String concatFragments(Function<QueryFragment, String> supplier) {
        int line = 1;
        StringBuilder stringBuilder = new StringBuilder();
        for (QueryFragment fragment : this.fragments) {
            if (line != fragment.getLine()) {
                stringBuilder.append("\n");
                line = fragment.getLine();
            }
            stringBuilder.append(supplier.apply(fragment));
        }
        return stringBuilder.toString();
    }

    public QueryPosition backtrackPosition(QueryPosition interpolated) {
        List lineFragments = this.fragments.stream().filter(f -> f.getLine() == interpolated.beginLine()).collect(Collectors.toList());
        int linePosition = 0;
        for (QueryFragment fragment : lineFragments) {
            if (interpolated.beginColumn() >= linePosition && interpolated.endColumn() <= linePosition + fragment.originalLength()) {
                if (fragment.isInterpolated()) {
                    return QueryPosition.create(fragment.getLine(), fragment.getOriginalBeginColumn(), fragment.getLine(), fragment.getOriginalEndColumn());
                }
                int offsetStart = interpolated.beginColumn() - linePosition;
                int offsetEnd = linePosition + fragment.interpolatedLength() - interpolated.endColumn();
                int globalOriginalStart = fragment.getOriginalBeginColumn() + offsetStart;
                int globalOriginalEnd = fragment.getOriginalBeginColumn() + fragment.originalLength() - offsetEnd;
                return QueryPosition.create(interpolated.beginLine(), globalOriginalStart, interpolated.endLine(), globalOriginalEnd);
            }
            linePosition += fragment.interpolatedLength();
        }
        throw new IllegalArgumentException("Failed to backtrack position: " + String.valueOf(interpolated));
    }
}

