/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine.suggestions;

import java.util.Arrays;
import java.util.function.Predicate;
import org.graylog2.indexer.fieldtypes.FieldTypeMapper;
import org.graylog2.indexer.fieldtypes.FieldTypes;

public enum SuggestionFieldType {
    TEXTUAL(type -> type.properties().contains((Object)"full-text-search") || FieldTypeMapper.STRING_TYPE.equals(type)),
    NUMERICAL(field -> field.properties().contains((Object)"numeric")),
    OTHER(props -> false);

    private final Predicate<FieldTypes.Type> matchesFieldProperty;

    private SuggestionFieldType(Predicate<FieldTypes.Type> matchesFieldProperty) {
        this.matchesFieldProperty = matchesFieldProperty;
    }

    public static SuggestionFieldType fromFieldType(FieldTypes.Type field) {
        return Arrays.stream(SuggestionFieldType.values()).filter(it -> it.matchesFieldProperty.test(field)).findFirst().orElse(OTHER);
    }
}

