/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.engine.QuerySuggestionsService;
import org.graylog.plugins.views.search.engine.suggestions.FieldValueSuggestionMode;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionFieldType;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionRequest;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionResponse;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.querystrings.LastUsedQueryStringsService;
import org.graylog.plugins.views.search.querystrings.QueryString;
import org.graylog.plugins.views.search.rest.MappedFieldTypeDTO;
import org.graylog.plugins.views.search.rest.PermittedStreams;
import org.graylog.plugins.views.search.rest.suggestions.SuggestionEntryDTO;
import org.graylog.plugins.views.search.rest.suggestions.SuggestionsDTO;
import org.graylog.plugins.views.search.rest.suggestions.SuggestionsErrorDTO;
import org.graylog.plugins.views.search.rest.suggestions.SuggestionsRequestDTO;
import org.graylog2.Configuration;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeService;
import org.graylog2.indexer.fieldtypes.FieldTypeMapper;
import org.graylog2.indexer.fieldtypes.FieldTypes;
import org.graylog2.indexer.fieldtypes.MappedFieldTypesService;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.resources.system.contentpacks.titles.EntityTitleService;
import org.graylog2.rest.resources.system.contentpacks.titles.model.EntityIdentifier;
import org.graylog2.rest.resources.system.contentpacks.titles.model.EntityTitleRequest;
import org.graylog2.rest.resources.system.contentpacks.titles.model.EntityTitleResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Search/Suggestions", tags={"cloud"})
@Path(value="/search/suggest")
@Produces(value={"application/json"})
public class SuggestionsResource
extends RestResource
implements PluginRestResource {
    public static final int SUGGESTIONS_COUNT_MAX = 100;
    private final PermittedStreams permittedStreams;
    private final QuerySuggestionsService querySuggestionsService;
    private final MappedFieldTypesService mappedFieldTypesService;
    private final EntityTitleService entityTitleService;
    private final NodeService nodeService;
    private final LastUsedQueryStringsService lastUsedQueryStringsService;
    private final FieldValueSuggestionMode fieldValueSuggestionMode;

    @Inject
    public SuggestionsResource(PermittedStreams permittedStreams, QuerySuggestionsService querySuggestionsService, MappedFieldTypesService mappedFieldTypesService, EntityTitleService entityTitleService, NodeService nodeService, LastUsedQueryStringsService lastUsedQueryStringsService, Configuration configuration) {
        this.permittedStreams = permittedStreams;
        this.querySuggestionsService = querySuggestionsService;
        this.mappedFieldTypesService = mappedFieldTypesService;
        this.entityTitleService = entityTitleService;
        this.nodeService = nodeService;
        this.lastUsedQueryStringsService = lastUsedQueryStringsService;
        this.fieldValueSuggestionMode = configuration.getFieldValueSuggestionMode();
    }

    @GET
    @Path(value="/query_strings")
    @ApiOperation(value="Suggest last used query strings")
    public List<QueryString> suggestQueryStrings(@Context SearchUser searchUser, @ApiParam(value="limit") @QueryParam(value="limit") Integer limit) {
        return this.lastUsedQueryStringsService.get(searchUser.getUser(), Optional.ofNullable(limit).orElse(10));
    }

    @POST
    @ApiOperation(value="Suggest field value")
    @NoAuditEvent(value="Only suggesting field value for query, not changing any data")
    public SuggestionsDTO suggestFieldValue(@ApiParam(name="validationRequest") SuggestionsRequestDTO suggestionsRequest, @Context SearchUser searchUser) {
        if (this.fieldValueSuggestionMode == FieldValueSuggestionMode.OFF) {
            return this.getNoSuggestionResponse(suggestionsRequest.field(), suggestionsRequest.input());
        }
        Set<String> streams = this.adaptStreams(suggestionsRequest.streams(), searchUser);
        TimeRange timerange = Optional.ofNullable(suggestionsRequest.timerange()).orElse(this.defaultTimeRange());
        String fieldName = suggestionsRequest.field();
        SuggestionFieldType suggestionFieldType = this.getFieldType(streams, timerange, fieldName);
        if (this.fieldValueSuggestionMode == FieldValueSuggestionMode.TEXTUAL_ONLY && suggestionFieldType != SuggestionFieldType.TEXTUAL) {
            return this.getNoSuggestionResponse(suggestionsRequest.field(), suggestionsRequest.input());
        }
        Set<MappedFieldTypeDTO> fieldTypes = this.mappedFieldTypesService.fieldTypesByStreamIds(streams, timerange);
        FieldTypes.Type fieldType = fieldTypes.stream().filter(f -> f.name().equals(fieldName)).findFirst().map(MappedFieldTypeDTO::type).orElse(FieldTypes.Type.createType("unknown", Collections.emptySet()));
        SuggestionRequest req = SuggestionRequest.builder().field(fieldName).fieldType(suggestionFieldType).input(suggestionsRequest.input()).streams(streams).size(Math.min(suggestionsRequest.size(), 100)).timerange(timerange).build();
        SuggestionResponse res = this.querySuggestionsService.suggest(req);
        List<SuggestionEntryDTO> suggestions = this.augmentSuggestions(res.suggestions().stream().map(s -> SuggestionEntryDTO.create(s.getValue(), s.getOccurrence())).toList(), fieldType, searchUser);
        SuggestionsDTO.Builder suggestionsBuilder = SuggestionsDTO.builder(res.field(), res.input()).suggestions(suggestions).sumOtherDocsCount(res.sumOtherDocsCount());
        res.suggestionError().map(e -> SuggestionsErrorDTO.create(e.type(), e.reason())).ifPresent(suggestionsBuilder::error);
        return suggestionsBuilder.build();
    }

    private List<SuggestionEntryDTO> augmentSuggestions(List<SuggestionEntryDTO> suggestions, FieldTypes.Type fieldType, SearchUser searchUser) {
        if (fieldType.equals(FieldTypeMapper.STREAMS_TYPE) || fieldType.equals(FieldTypeMapper.INPUT_TYPE)) {
            List<EntityIdentifier> entityIds = suggestions.stream().map(SuggestionEntryDTO::value).distinct().map(value -> new EntityIdentifier((String)value, this.mapEntityType(fieldType.type()))).toList();
            Map<String, String> results = this.entityTitleService.getTitles(new EntityTitleRequest(entityIds), searchUser).entities().stream().collect(Collectors.toMap(EntityTitleResponse::id, EntityTitleResponse::title));
            return suggestions.stream().map(s -> SuggestionEntryDTO.create(s.value(), s.occurrence(), Optional.ofNullable((String)results.get(s.value())))).toList();
        }
        if (fieldType.equals(FieldTypeMapper.NODE_TYPE)) {
            List<String> nodeIds = suggestions.stream().map(SuggestionEntryDTO::value).distinct().toList();
            Map<String, Node> results = this.nodeService.byNodeIds(nodeIds);
            return suggestions.stream().map(s -> SuggestionEntryDTO.create(s.value(), s.occurrence(), Optional.ofNullable((Node)results.get(s.value())).map(Node::getTitle))).toList();
        }
        return suggestions;
    }

    private String mapEntityType(String type) {
        return switch (type) {
            case "streams" -> "streams";
            case "input" -> "inputs";
            default -> throw new IllegalStateException("Unexpected value: " + type);
        };
    }

    private Set<String> adaptStreams(Set<String> streams, SearchUser searchUser) {
        if (streams == null || streams.isEmpty()) {
            return this.loadAllAllowedStreamsForUser(searchUser);
        }
        return streams.stream().filter(searchUser::canReadStream).collect(Collectors.toSet());
    }

    private RelativeRange defaultTimeRange() {
        return RelativeRange.create(300);
    }

    private ImmutableSet<String> loadAllAllowedStreamsForUser(SearchUser searchUser) {
        return this.permittedStreams.loadAllMessageStreams(searchUser);
    }

    private SuggestionFieldType getFieldType(Set<String> streams, TimeRange timerange, String fieldName) {
        Set<MappedFieldTypeDTO> fieldTypes = this.mappedFieldTypesService.fieldTypesByStreamIds(streams, timerange);
        return fieldTypes.stream().filter(f -> f.name().equals(fieldName)).findFirst().map(MappedFieldTypeDTO::type).map(SuggestionFieldType::fromFieldType).orElse(SuggestionFieldType.OTHER);
    }

    private SuggestionsDTO getNoSuggestionResponse(String fieldName, String input) {
        return SuggestionsDTO.builder(fieldName, input).suggestions(List.of()).sumOtherDocsCount(0L).build();
    }
}

