/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.AggregationSpecToPivotMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.MessagesSpecToMessageListMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.request.AggregationRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.request.MessagesRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.request.SearchRequestSpec;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class SearchRequestSpecToSearchMapper {
    public static final String QUERY_ID = "scripting_api_temporary_query";
    private final AggregationSpecToPivotMapper pivotCreator;
    private final MessagesSpecToMessageListMapper messageListCreator;

    @Inject
    public SearchRequestSpecToSearchMapper(AggregationSpecToPivotMapper pivotCreator, MessagesSpecToMessageListMapper messageListCreator) {
        this.pivotCreator = pivotCreator;
        this.messageListCreator = messageListCreator;
    }

    public Search mapToSearch(MessagesRequestSpec messagesRequestSpec, SearchUser searchUser) {
        return this.mapToSearch(messagesRequestSpec, searchUser, this.messageListCreator);
    }

    public Search mapToSearch(AggregationRequestSpec aggregationRequestSpec, SearchUser searchUser) {
        return this.mapToSearch(aggregationRequestSpec, searchUser, this.pivotCreator);
    }

    private <T extends SearchRequestSpec> Search mapToSearch(T searchRequestSpec, SearchUser searchUser, Function<T, ? extends SearchType> searchTypeCreator) {
        Query query = Query.builder().id(QUERY_ID).searchTypes(Set.of(searchTypeCreator.apply(searchRequestSpec))).query(ElasticsearchQueryString.ofNullable(searchRequestSpec.queryString())).timerange(this.getTimerange(searchRequestSpec)).build();
        if (!searchRequestSpec.streams().isEmpty()) {
            query = query.addStreamsToFilter(new HashSet<String>(searchRequestSpec.streams()));
        }
        return Search.builder().queries((ImmutableSet<Query>)ImmutableSet.of((Object)query)).build().addStreamsToQueriesWithoutStreams(() -> searchUser.streams().readableOrAllIfEmpty(searchRequestSpec.streams()));
    }

    private TimeRange getTimerange(SearchRequestSpec searchRequestSpec) {
        return searchRequestSpec.timerange() != null ? searchRequestSpec.timerange() : RelativeRange.allTime();
    }
}

