/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.graylog.plugins.views.search.rest.scriptingapi.response.ResponseEntryDataType;
import org.graylog.plugins.views.search.rest.scriptingapi.response.ResponseEntryType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record ResponseSchemaEntry(@JsonProperty(value="column_type") ResponseEntryType type, @JsonProperty(value="type") ResponseEntryDataType dataType, @JsonProperty(value="function") String functionName, @JsonProperty(value="field") String fieldName) {
    public static ResponseSchemaEntry groupBy(String fieldName) {
        Objects.requireNonNull(fieldName);
        return new ResponseSchemaEntry(ResponseEntryType.GROUPING, ResponseEntryDataType.STRING, null, fieldName);
    }

    public static ResponseSchemaEntry metric(String functionName, String fieldName) {
        Objects.requireNonNull(functionName);
        ResponseEntryDataType dataType = "latest".equals(functionName) ? ResponseEntryDataType.STRING : ResponseEntryDataType.NUMERIC;
        return new ResponseSchemaEntry(ResponseEntryType.METRIC, dataType, functionName, fieldName);
    }

    public static ResponseSchemaEntry field(String fieldName, ResponseEntryDataType dataType) {
        return new ResponseSchemaEntry(ResponseEntryType.FIELD, dataType, null, fieldName);
    }

    @JsonProperty
    public String name() {
        return String.valueOf((Object)this.type) + ": " + this.getFunctionLabel();
    }

    private String getFunctionLabel() {
        if (this.functionName != null) {
            String safeFieldName = Optional.ofNullable(this.fieldName).orElse("");
            return String.format(Locale.ROOT, "%s(%s)", this.functionName, safeFieldName);
        }
        return this.fieldName;
    }
}

