/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.response.writers;

import au.com.bytecode.opencsv.CSVWriter;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.skb.interfaces.transformers.textformat.TextAlignment;
import jakarta.inject.Inject;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.rest.scriptingapi.response.ResponseSchemaEntry;
import org.graylog.plugins.views.search.rest.scriptingapi.response.TabularResponse;

@Provider
@Produces(value={"application/json", "text/csv", "text/plain"})
public class TabularResponseWriter
implements MessageBodyWriter<TabularResponse> {
    private final ObjectMapper objectMapper;

    @Inject
    public TabularResponseWriter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return aClass.equals(TabularResponse.class);
    }

    public void writeTo(TabularResponse tabularResponse, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        switch (mediaType.toString()) {
            case "application/json": {
                this.writeJson(tabularResponse, outputStream);
                break;
            }
            case "text/plain": {
                this.writeAsciiTable(tabularResponse, outputStream);
                break;
            }
            case "text/csv": {
                this.writeCsv(tabularResponse, outputStream);
                break;
            }
            default: {
                throw new IllegalArgumentException("Media type " + String.valueOf(mediaType) + " not supported");
            }
        }
    }

    private void writeJson(TabularResponse tabularResponse, OutputStream outputStream) throws IOException {
        this.objectMapper.writeValue(outputStream, (Object)tabularResponse);
    }

    private void writeAsciiTable(TabularResponse response, OutputStream outputStream) {
        try (PrintStream printStream = new PrintStream(outputStream, true, StandardCharsets.UTF_8);){
            printStream.print(TabularResponseWriter.renderAsciiTable(response));
        }
    }

    private void writeCsv(TabularResponse response, OutputStream outputStream) throws IOException {
        try (CSVWriter csvWriter = new CSVWriter((Writer)new PrintWriter(outputStream, true, StandardCharsets.UTF_8));){
            csvWriter.writeNext((String[])response.schema().stream().map(ResponseSchemaEntry::name).toArray(String[]::new));
            response.datarows().stream().map(row -> (String[])row.stream().map(String::valueOf).toArray(String[]::new)).forEach(arg_0 -> ((CSVWriter)csvWriter).writeNext(arg_0));
        }
    }

    private static String renderAsciiTable(TabularResponse response) {
        AsciiTable at = new AsciiTable();
        at.getContext().setWidth(response.schema().size() * 25);
        at.addRule();
        at.addRow((Collection)response.schema().stream().map(ResponseSchemaEntry::name).collect(Collectors.toList()));
        at.addRule();
        response.datarows().stream().map(TabularResponseWriter::serialize).forEach(arg_0 -> ((AsciiTable)at).addRow(arg_0));
        at.addRule();
        at.setTextAlignment(TextAlignment.LEFT);
        return at.render();
    }

    private static List<String> serialize(List<Object> values) {
        return values.stream().map(TabularResponseWriter::serialize).collect(Collectors.toList());
    }

    private static String serialize(Object val) {
        if (val instanceof Collection) {
            Collection collection = (Collection)val;
            return collection.stream().map(String::valueOf).collect(Collectors.joining(", "));
        }
        return String.valueOf(val);
    }
}

