/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchfilters.db;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SearchFilterVisibilityCheckStatus {
    private final List<String> hiddenSearchFiltersIDs;

    public SearchFilterVisibilityCheckStatus() {
        this.hiddenSearchFiltersIDs = Collections.emptyList();
    }

    public SearchFilterVisibilityCheckStatus(List<String> hiddenSearchFiltersIDs) {
        this.hiddenSearchFiltersIDs = hiddenSearchFiltersIDs;
    }

    public List<String> getHiddenSearchFiltersIDs() {
        return this.hiddenSearchFiltersIDs;
    }

    public boolean allSearchFiltersVisible() {
        return this.hiddenSearchFiltersIDs.isEmpty();
    }

    public boolean allSearchFiltersVisible(Collection<String> allowedHiddenSearchFilters) {
        return this.hiddenSearchFiltersIDs.isEmpty() || allowedHiddenSearchFilters != null && allowedHiddenSearchFilters.containsAll(this.hiddenSearchFiltersIDs);
    }

    public String toMessage() {
        if (!this.allSearchFiltersVisible()) {
            return "View cannot be saved, as it contains Search Filters which you are not privileged to view : " + this.hiddenSearchFiltersIDs.toString();
        }
        return "View can be created with provided list of Search Filters";
    }

    public String toMessage(Collection<String> allowedHiddenSearchFilters) {
        if (!this.allSearchFiltersVisible(allowedHiddenSearchFilters)) {
            return "View cannot be saved, as it contains Search Filters which you are not privileged to view : " + String.valueOf(this.hiddenSearchFiltersIDs.stream().filter(f -> !allowedHiddenSearchFilters.contains(f)).collect(Collectors.toList()));
        }
        return "View can be created with provided list of Search Filters";
    }
}

