/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.graylog.plugins.views.search.validation.ParsedQuery;
import org.graylog.plugins.views.search.validation.TermCollectingQueryVisitor;
import org.graylog.plugins.views.search.validation.TokenCollectingQueryParser;

public class LuceneQueryParser {
    public static final Analyzer ANALYZER = new WhitespaceAnalyzer();
    private final boolean allowLeadingWildcard;

    @Inject
    public LuceneQueryParser(@Named(value="allow_leading_wildcard_searches") boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
    }

    public ParsedQuery parse(String query) throws ParseException {
        TokenCollectingQueryParser parser = new TokenCollectingQueryParser("_default_", ANALYZER);
        parser.setSplitOnWhitespace(true);
        parser.setAllowLeadingWildcard(this.allowLeadingWildcard);
        Query parsed = parser.parse(query);
        ParsedQuery.Builder builder = ParsedQuery.builder().query(query);
        builder.tokensBuilder().addAll(parser.getTokens());
        TermCollectingQueryVisitor visitor = new TermCollectingQueryVisitor(ANALYZER, parser.getTokenLookup());
        parsed.visit((QueryVisitor)visitor);
        builder.termsBuilder().addAll(visitor.getParsedTerms());
        return builder.build();
    }
}

