/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.storage.migration.state.persistence;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachineContext;
import org.graylog.plugins.views.storage.migration.state.persistence.DatanodeMigrationConfiguration;
import org.graylog.plugins.views.storage.migration.state.persistence.DatanodeMigrationPersistence;
import org.graylog2.plugin.cluster.ClusterConfigService;

@Singleton
public class DatanodeMigrationConfigurationImpl
implements DatanodeMigrationPersistence {
    private final ClusterConfigService clusterConfigService;

    @Inject
    public DatanodeMigrationConfigurationImpl(ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public Optional<DatanodeMigrationConfiguration> getConfiguration() {
        return Optional.ofNullable(this.clusterConfigService.get(DatanodeMigrationConfiguration.class));
    }

    @Override
    public void saveConfiguration(DatanodeMigrationConfiguration configuration) {
        this.clusterConfigService.write(configuration);
    }

    @Override
    public Optional<MigrationStateMachineContext> getStateMachineContext() {
        return Optional.ofNullable(this.clusterConfigService.get(MigrationStateMachineContext.class));
    }

    @Override
    public void saveStateMachineContext(MigrationStateMachineContext context) {
        this.clusterConfigService.write(context);
    }
}

