/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.ldap;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.security.authservice.ldap.LDAPConnectorConfig;
import org.graylog.security.authservice.ldap.LDAPTransportSecurity;
import org.graylog2.security.encryption.EncryptedValue;

final class AutoValue_LDAPConnectorConfig
extends LDAPConnectorConfig {
    private final Optional<String> systemUsername;
    private final EncryptedValue systemPassword;
    private final ImmutableList<LDAPConnectorConfig.LDAPServer> serverList;
    private final LDAPTransportSecurity transportSecurity;
    private final boolean verifyCertificates;

    private AutoValue_LDAPConnectorConfig(Optional<String> systemUsername, EncryptedValue systemPassword, ImmutableList<LDAPConnectorConfig.LDAPServer> serverList, LDAPTransportSecurity transportSecurity, boolean verifyCertificates) {
        this.systemUsername = systemUsername;
        this.systemPassword = systemPassword;
        this.serverList = serverList;
        this.transportSecurity = transportSecurity;
        this.verifyCertificates = verifyCertificates;
    }

    @Override
    public Optional<String> systemUsername() {
        return this.systemUsername;
    }

    @Override
    public EncryptedValue systemPassword() {
        return this.systemPassword;
    }

    @Override
    public ImmutableList<LDAPConnectorConfig.LDAPServer> serverList() {
        return this.serverList;
    }

    @Override
    public LDAPTransportSecurity transportSecurity() {
        return this.transportSecurity;
    }

    @Override
    public boolean verifyCertificates() {
        return this.verifyCertificates;
    }

    public String toString() {
        return "LDAPConnectorConfig{systemUsername=" + String.valueOf(this.systemUsername) + ", systemPassword=" + String.valueOf(this.systemPassword) + ", serverList=" + String.valueOf(this.serverList) + ", transportSecurity=" + String.valueOf((Object)this.transportSecurity) + ", verifyCertificates=" + this.verifyCertificates + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LDAPConnectorConfig) {
            LDAPConnectorConfig that = (LDAPConnectorConfig)o;
            return this.systemUsername.equals(that.systemUsername()) && this.systemPassword.equals(that.systemPassword()) && this.serverList.equals(that.serverList()) && this.transportSecurity.equals((Object)that.transportSecurity()) && this.verifyCertificates == that.verifyCertificates();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.systemUsername.hashCode();
        h$ *= 1000003;
        h$ ^= this.systemPassword.hashCode();
        h$ *= 1000003;
        h$ ^= this.serverList.hashCode();
        h$ *= 1000003;
        h$ ^= this.transportSecurity.hashCode();
        h$ *= 1000003;
        return h$ ^= this.verifyCertificates ? 1231 : 1237;
    }

    @Override
    public LDAPConnectorConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends LDAPConnectorConfig.Builder {
        private Optional<String> systemUsername = Optional.empty();
        private EncryptedValue systemPassword;
        private ImmutableList<LDAPConnectorConfig.LDAPServer> serverList;
        private LDAPTransportSecurity transportSecurity;
        private boolean verifyCertificates;
        private byte set$0;

        Builder() {
        }

        private Builder(LDAPConnectorConfig source) {
            this.systemUsername = source.systemUsername();
            this.systemPassword = source.systemPassword();
            this.serverList = source.serverList();
            this.transportSecurity = source.transportSecurity();
            this.verifyCertificates = source.verifyCertificates();
            this.set$0 = 1;
        }

        @Override
        public LDAPConnectorConfig.Builder systemUsername(@Nullable String systemUsername) {
            this.systemUsername = Optional.ofNullable(systemUsername);
            return this;
        }

        @Override
        public LDAPConnectorConfig.Builder systemPassword(EncryptedValue systemPassword) {
            if (systemPassword == null) {
                throw new NullPointerException("Null systemPassword");
            }
            this.systemPassword = systemPassword;
            return this;
        }

        @Override
        public LDAPConnectorConfig.Builder serverList(List<LDAPConnectorConfig.LDAPServer> serverList) {
            this.serverList = ImmutableList.copyOf(serverList);
            return this;
        }

        @Override
        public LDAPConnectorConfig.Builder transportSecurity(LDAPTransportSecurity transportSecurity) {
            if (transportSecurity == null) {
                throw new NullPointerException("Null transportSecurity");
            }
            this.transportSecurity = transportSecurity;
            return this;
        }

        @Override
        public LDAPConnectorConfig.Builder verifyCertificates(boolean verifyCertificates) {
            this.verifyCertificates = verifyCertificates;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public LDAPConnectorConfig build() {
            if (this.set$0 != 1 || this.systemPassword == null || this.serverList == null || this.transportSecurity == null) {
                StringBuilder missing = new StringBuilder();
                if (this.systemPassword == null) {
                    missing.append(" systemPassword");
                }
                if (this.serverList == null) {
                    missing.append(" serverList");
                }
                if (this.transportSecurity == null) {
                    missing.append(" transportSecurity");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" verifyCertificates");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_LDAPConnectorConfig(this.systemUsername, this.systemPassword, this.serverList, this.transportSecurity, this.verifyCertificates);
        }
    }
}

