/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.rest;

import jakarta.ws.rs.ForbiddenException;
import org.apache.shiro.authz.Permission;
import org.graylog.grn.GRN;
import org.graylog.security.permissions.GRNPermission;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestResourceWithOwnerCheck
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(RestResource.class);

    protected void checkOwnership(GRN entity) {
        if (!this.isOwner(entity)) {
            LOG.info("Not authorized to access entity <{}>. User <{}> is missing permission <{}:{}>", new Object[]{entity, this.getSubject().getPrincipal(), "entity:own", entity});
            throw new ForbiddenException("Not authorized to access entity <" + String.valueOf(entity) + ">");
        }
    }

    protected boolean isOwner(GRN entity) {
        return this.isPermitted("entity:own", entity);
    }

    protected boolean isPermitted(String type, GRN target) {
        return this.getSubject().isPermitted((Permission)GRNPermission.create(type, target));
    }
}

