/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.Validator;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.converters.StringSetConverter;
import com.github.joschi.jadconfig.converters.TrimmedStringSetConverter;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.github.joschi.jadconfig.validators.PositiveLongValidator;
import com.github.joschi.jadconfig.validators.StringNotBlankValidator;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.graylog.plugins.views.search.engine.suggestions.FieldValueSuggestionMode;
import org.graylog.plugins.views.search.engine.suggestions.FieldValueSuggestionModeConverter;
import org.graylog.security.certutil.CaConfiguration;
import org.graylog2.bindings.NamedBindingOverride;
import org.graylog2.cluster.leader.AutomaticLeaderElectionService;
import org.graylog2.cluster.leader.LeaderElectionMode;
import org.graylog2.cluster.lock.MongoLockService;
import org.graylog2.configuration.converters.JavaDurationConverter;
import org.graylog2.notifications.Notification;
import org.graylog2.plugin.Tools;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.utilities.IPSubnetConverter;
import org.graylog2.utilities.IpSubnet;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;

public class Configuration
extends CaConfiguration {
    public static final String SAFE_CLASSES = "safe_classes";
    public static final String CONTENT_PACKS_DIR = "content_packs_dir";
    @Parameter(value="is_master")
    private boolean isMaster = true;
    @Parameter(value="stream_aware_field_types")
    private boolean streamAwareFieldTypes = false;
    @Parameter(value="is_leader")
    private Boolean isLeader;
    @Parameter(value="password_secret", required=true, validators={StringNotBlankValidator.class})
    private String passwordSecret;
    @Parameter(value="output_batch_size", required=true, validators={PositiveIntegerValidator.class})
    private int outputBatchSize = 500;
    @Parameter(value="output_flush_interval", required=true, validators={PositiveIntegerValidator.class})
    private int outputFlushInterval = 1;
    @Parameter(value="outputbuffer_processors", required=true, validators={PositiveIntegerValidator.class})
    private int outputBufferProcessors = Configuration.defaultNumberOfOutputBufferProcessors();
    @Parameter(value="outputbuffer_processor_threads_core_pool_size", required=true, validators={PositiveIntegerValidator.class})
    private int outputBufferProcessorThreadsCorePoolSize = 3;
    @Parameter(value="node_id_file", validators={NodeIdFileValidator.class})
    private String nodeIdFile = "/etc/graylog/server/node-id";
    @Parameter(value="root_username")
    private String rootUsername = "admin";
    @Parameter(value="root_password_sha2")
    private String rootPasswordSha2;
    @Parameter(value="root_timezone")
    private DateTimeZone rootTimeZone = DateTimeZone.UTC;
    @Parameter(value="root_email")
    private String rootEmail = "";
    @Parameter(value="allow_leading_wildcard_searches")
    private boolean allowLeadingWildcardSearches = false;
    @Parameter(value="allow_highlighting")
    private boolean allowHighlighting = false;
    @Parameter(value="lb_recognition_period_seconds", validators={PositiveIntegerValidator.class})
    private int loadBalancerRecognitionPeriodSeconds = 3;
    @Parameter(value="lb_throttle_threshold_percentage", validators={PositiveIntegerValidator.class})
    private int loadBalancerThrottleThresholdPercentage = 100;
    @Parameter(value="stream_processing_timeout", validators={PositiveLongValidator.class})
    private long streamProcessingTimeout = 2000L;
    @Parameter(value="stream_processing_max_faults", validators={PositiveIntegerValidator.class})
    private int streamProcessingMaxFaults = 3;
    @Parameter(value="output_module_timeout", validators={PositiveLongValidator.class})
    private long outputModuleTimeout = 10000L;
    @Parameter(value="output_fault_count_threshold", validators={PositiveLongValidator.class})
    private long outputFaultCountThreshold = 5L;
    @Parameter(value="output_fault_penalty_seconds", validators={PositiveLongValidator.class})
    private long outputFaultPenaltySeconds = 30L;
    @Parameter(value="stale_master_timeout", validators={PositiveIntegerValidator.class})
    private int staleMasterTimeout = 2000;
    @Parameter(value="stale_leader_timeout", validators={PositiveIntegerValidator.class})
    private Integer staleLeaderTimeout;
    @Parameter(value="ldap_connection_timeout", validators={PositiveIntegerValidator.class})
    private int ldapConnectionTimeout = 2000;
    @Parameter(value="alert_check_interval", validators={PositiveIntegerValidator.class})
    @Deprecated
    private int alertCheckInterval = 60;
    @Parameter(value="default_message_output_class")
    private String defaultMessageOutputClass = "";
    @Parameter(value="dashboard_widget_default_cache_time", validators={PositiveDurationValidator.class})
    private com.github.joschi.jadconfig.util.Duration dashboardWidgetDefaultCacheTime = com.github.joschi.jadconfig.util.Duration.seconds((long)10L);
    @Parameter(value="user_password_default_algorithm")
    private String userPasswordDefaultAlgorithm = "bcrypt";
    @Parameter(value="user_password_bcrypt_salt_size", validators={PositiveIntegerValidator.class})
    private int userPasswordBCryptSaltSize = 10;
    @Parameter(value="content_packs_loader_enabled")
    private boolean contentPacksLoaderEnabled = false;
    @Parameter(value="content_packs_dir")
    private Path contentPacksDir;
    @Parameter(value="content_packs_auto_install", converter=TrimmedStringSetConverter.class)
    private Set<String> contentPacksAutoInstall = Collections.emptySet();
    @Parameter(value="index_ranges_cleanup_interval", validators={PositiveDurationValidator.class})
    private com.github.joschi.jadconfig.util.Duration indexRangesCleanupInterval = com.github.joschi.jadconfig.util.Duration.hours((long)1L);
    @Parameter(value="trusted_proxies", converter=IPSubnetConverter.class)
    private Set<IpSubnet> trustedProxies = Collections.emptySet();
    @Parameter(value="deactivated_builtin_authentication_providers", converter=StringSetConverter.class)
    private Set<String> deactivatedBuiltinAuthenticationProviders = Collections.emptySet();
    @Parameter(value="enabled_tls_protocols", converter=StringSetConverter.class)
    private Set<String> enabledTlsProtocols = null;
    @Parameter(value="failure_handling_queue_capacity", validators={PositiveIntegerValidator.class})
    private int failureHandlingQueueCapacity = 1000;
    @Parameter(value="failure_handling_shutdown_await", validators={PositiveDurationValidator.class})
    private com.github.joschi.jadconfig.util.Duration failureHandlingShutdownAwait = com.github.joschi.jadconfig.util.Duration.milliseconds((long)3000L);
    @Parameter(value="is_cloud")
    private boolean isCloud = false;
    @Parameter(value="auto_restart_inputs")
    private boolean autoRestartInputs = false;
    @Parameter(value="run_migrations")
    private boolean runMigrations = true;
    @Parameter(value="ignore_migration_failures")
    private boolean ignoreMigrationFailures = false;
    @Parameter(value="skip_preflight_checks")
    private boolean skipPreflightChecks = false;
    @Parameter(value="enable_preflight_web")
    private boolean enablePreflightWeb = false;
    @Parameter(value="query_latency_monitoring_enabled")
    private boolean queryLatencyMonitoringEnabled = false;
    @Parameter(value="query_latency_monitoring_window_size")
    private int queryLatencyMonitoringWindowSize = 0;
    @Parameter(value="leader_election_mode", converter=LeaderElectionMode.Converter.class)
    private LeaderElectionMode leaderElectionMode = LeaderElectionMode.STATIC;
    @Parameter(value="leader_election_lock_polling_interval", converter=JavaDurationConverter.class)
    private Duration leaderElectionLockPollingInterval = AutomaticLeaderElectionService.DEFAULT_POLLING_INTERVAL;
    @Parameter(value="lock_service_lock_ttl", converter=JavaDurationConverter.class)
    private Duration lockServiceLockTTL = MongoLockService.MIN_LOCK_TTL;
    @Parameter(value="system_event_excluded_types", converter=TrimmedStringSetConverter.class)
    private Set<String> systemEventExcludedTypes = Sets.newHashSet((Object[])new String[]{Notification.Type.SIDECAR_STATUS_UNKNOWN.name()});
    @Parameter(value="datanode_proxy_api_allowlist")
    private boolean datanodeProxyAPIAllowlist = true;
    @Parameter(value="minimum_auto_refresh_interval", required=true)
    private Period minimumAutoRefreshInterval = Period.seconds((int)1);
    @Parameter(value="safe_classes", converter=StringSetConverter.class, validators={SafeClassesValidator.class})
    private Set<String> safeClasses = Set.of("org.graylog.", "org.graylog2.");
    @Parameter(value="field_value_suggestion_mode", required=true, converter=FieldValueSuggestionModeConverter.class)
    private FieldValueSuggestionMode fieldValueSuggestionMode = FieldValueSuggestionMode.ON;
    public static final String INSTALL_HTTP_CONNECTION_TIMEOUT = "install_http_connection_timeout";
    public static final String INSTALL_OUTPUT_BUFFER_DRAINING_INTERVAL = "install_output_buffer_drain_interval";
    public static final String INSTALL_OUTPUT_BUFFER_DRAINING_MAX_RETRIES = "install_output_buffer_max_retries";
    private static final int DEFAULT_INSTALL_RETRIES = 150;
    private static final com.github.joschi.jadconfig.util.Duration DEFAULT_INSTALL_SECONDS = com.github.joschi.jadconfig.util.Duration.seconds((long)2L);
    @Parameter(value="install_http_connection_timeout", validators={PositiveDurationValidator.class})
    private com.github.joschi.jadconfig.util.Duration installHttpConnectionTimeout = com.github.joschi.jadconfig.util.Duration.seconds((long)10L);
    @Parameter(value="install_output_buffer_drain_interval", validators={PositiveDurationValidator.class})
    private com.github.joschi.jadconfig.util.Duration installOutputBufferDrainingInterval = DEFAULT_INSTALL_SECONDS;
    @Parameter(value="install_output_buffer_max_retries", validators={PositiveIntegerValidator.class})
    private int installOutputBufferDrainingMaxRetries = 150;

    public boolean maintainsStreamAwareFieldTypes() {
        return this.streamAwareFieldTypes;
    }

    @Deprecated
    public boolean isMaster() {
        return this.isLeader();
    }

    public boolean isLeader() {
        return this.isLeader != null ? this.isLeader : this.isMaster;
    }

    @Deprecated
    public void setIsMaster(boolean is) {
        this.setIsLeader(is);
    }

    public void setIsLeader(boolean is) {
        this.isMaster = is;
        this.isLeader = this.isMaster;
    }

    public LeaderElectionMode getLeaderElectionMode() {
        return this.leaderElectionMode;
    }

    public Duration getLockServiceLockTTL() {
        return this.lockServiceLockTTL;
    }

    public Set<String> getSystemEventExcludedTypes() {
        return this.systemEventExcludedTypes;
    }

    public Duration getLeaderElectionLockPollingInterval() {
        return this.leaderElectionLockPollingInterval;
    }

    public String getPasswordSecret() {
        return this.passwordSecret.trim();
    }

    public int getOutputBatchSize() {
        return this.outputBatchSize;
    }

    public int getOutputFlushInterval() {
        return this.outputFlushInterval;
    }

    public int getOutputBufferProcessors() {
        return this.outputBufferProcessors;
    }

    public int getOutputBufferProcessorThreadsCorePoolSize() {
        return this.outputBufferProcessorThreadsCorePoolSize;
    }

    public boolean isCloud() {
        return this.isCloud;
    }

    public boolean getAutoRestartInputs() {
        return this.autoRestartInputs;
    }

    public boolean runMigrations() {
        return this.runMigrations;
    }

    public boolean ignoreMigrationFailures() {
        return this.ignoreMigrationFailures;
    }

    public boolean getSkipPreflightChecks() {
        return this.skipPreflightChecks;
    }

    public String getNodeIdFile() {
        return this.nodeIdFile;
    }

    public String getRootUsername() {
        return this.rootUsername;
    }

    public String getRootPasswordSha2() {
        return this.rootPasswordSha2;
    }

    public DateTimeZone getRootTimeZone() {
        return this.rootTimeZone;
    }

    public String getRootEmail() {
        return this.rootEmail;
    }

    public boolean isAllowLeadingWildcardSearches() {
        return this.allowLeadingWildcardSearches;
    }

    public boolean isAllowHighlighting() {
        return this.allowHighlighting;
    }

    public int getLoadBalancerRecognitionPeriodSeconds() {
        return this.loadBalancerRecognitionPeriodSeconds;
    }

    public long getStreamProcessingTimeout() {
        return this.streamProcessingTimeout;
    }

    public int getStreamProcessingMaxFaults() {
        return this.streamProcessingMaxFaults;
    }

    public long getOutputModuleTimeout() {
        return this.outputModuleTimeout;
    }

    public long getOutputFaultCountThreshold() {
        return this.outputFaultCountThreshold;
    }

    public long getOutputFaultPenaltySeconds() {
        return this.outputFaultPenaltySeconds;
    }

    @Deprecated
    public int getStaleMasterTimeout() {
        return this.getStaleLeaderTimeout();
    }

    public int getStaleLeaderTimeout() {
        return this.staleLeaderTimeout != null ? this.staleLeaderTimeout : this.staleMasterTimeout;
    }

    public int getLdapConnectionTimeout() {
        return this.ldapConnectionTimeout;
    }

    @Deprecated
    public int getAlertCheckInterval() {
        return this.alertCheckInterval;
    }

    public String getDefaultMessageOutputClass() {
        return this.defaultMessageOutputClass;
    }

    public com.github.joschi.jadconfig.util.Duration getDashboardWidgetDefaultCacheTime() {
        return this.dashboardWidgetDefaultCacheTime;
    }

    public String getUserPasswordDefaultAlgorithm() {
        return this.userPasswordDefaultAlgorithm;
    }

    public int getUserPasswordBCryptSaltSize() {
        return this.userPasswordBCryptSaltSize;
    }

    public boolean isContentPacksLoaderEnabled() {
        return this.contentPacksLoaderEnabled;
    }

    @NamedBindingOverride(value="content_packs_dir")
    public Path getContentPacksDir() {
        return Optional.ofNullable(this.contentPacksDir).orElse(this.getDataDir().resolve("contentpacks"));
    }

    public Set<String> getContentPacksAutoInstall() {
        return this.contentPacksAutoInstall;
    }

    public com.github.joschi.jadconfig.util.Duration getIndexRangesCleanupInterval() {
        return this.indexRangesCleanupInterval;
    }

    public Set<IpSubnet> getTrustedProxies() {
        return this.trustedProxies;
    }

    public int getLoadBalancerRequestThrottleJournalUsage() {
        return this.loadBalancerThrottleThresholdPercentage;
    }

    public Set<String> getDeactivatedBuiltinAuthenticationProviders() {
        return this.deactivatedBuiltinAuthenticationProviders;
    }

    public int getFailureHandlingQueueCapacity() {
        return this.failureHandlingQueueCapacity;
    }

    public com.github.joschi.jadconfig.util.Duration getFailureHandlingShutdownAwait() {
        return this.failureHandlingShutdownAwait;
    }

    public Period getMinimumAutoRefreshInterval() {
        return this.minimumAutoRefreshInterval;
    }

    public Set<String> getSafeClasses() {
        return this.safeClasses;
    }

    public FieldValueSuggestionMode getFieldValueSuggestionMode() {
        return this.fieldValueSuggestionMode;
    }

    @Deprecated
    public Set<String> getEnabledTlsProtocols() {
        return this.enabledTlsProtocols;
    }

    @ValidatorMethod
    public void validatePasswordSecret() throws ValidationException {
        String passwordSecret = this.getPasswordSecret();
        if (passwordSecret == null || passwordSecret.length() < 16) {
            throw new ValidationException("The minimum length for \"password_secret\" is 16 characters.");
        }
    }

    @ValidatorMethod
    public void validateRootUser() throws ValidationException {
        if (this.getRootPasswordSha2() == null && !this.isRootUserDisabled()) {
            throw new ValidationException("Required parameter \"root_password_sha2\" not found.");
        }
    }

    @ValidatorMethod
    public void validateLeaderElectionTimeouts() throws ValidationException {
        if (this.leaderElectionMode != LeaderElectionMode.AUTOMATIC) {
            return;
        }
        if (this.lockServiceLockTTL.compareTo(MongoLockService.MIN_LOCK_TTL) < 0) {
            throw new ValidationException("The minimum valid \"lock_service_lock_ttl\" is 60 seconds");
        }
        if (this.leaderElectionLockPollingInterval.compareTo(Duration.ofSeconds(1L)) < 0) {
            throw new ValidationException("The minimum valid \"leader_election_lock_polling_interval\" is 1 second");
        }
        if (this.lockServiceLockTTL.compareTo(this.leaderElectionLockPollingInterval) < 1) {
            throw new ValidationException("The \"leader_election_lock_polling_interval\" needs to be greater than the \"lock_service_lock_ttl\"!");
        }
    }

    public boolean isRootUserDisabled() {
        return this.getDeactivatedBuiltinAuthenticationProviders().contains("root-user");
    }

    public boolean enablePreflightWebserver() {
        return this.enablePreflightWeb;
    }

    public boolean isQueryLatencyMonitoringEnabled() {
        return this.queryLatencyMonitoringEnabled;
    }

    public int getQueryLatencyMonitoringWindowSize() {
        return this.queryLatencyMonitoringWindowSize;
    }

    private static int defaultNumberOfOutputBufferProcessors() {
        return Math.round((float)Tools.availableProcessors() * 0.162f + 0.625f);
    }

    public static class SafeClassesValidator
    implements Validator<Set<String>> {
        public void validate(String name, Set<String> set) throws ValidationException {
            if (set.isEmpty()) {
                throw new ValidationException(StringUtils.f("\"%s\" must not be empty. Please specify a comma-separated list of fully-qualified class name prefixes.", name));
            }
            if (set.stream().anyMatch(org.apache.commons.lang3.StringUtils::isBlank)) {
                throw new ValidationException(StringUtils.f("\"%s\" must only contain non-empty class name prefixes.", name));
            }
        }
    }

    public static class NodeIdFileValidator
    implements Validator<String> {
        public void validate(String name, String path) throws ValidationException {
            boolean empty;
            if (path == null) {
                return;
            }
            File file = Paths.get(path, new String[0]).toFile();
            StringBuilder b = new StringBuilder();
            if (!file.exists()) {
                File parent = file.getParentFile();
                if (!parent.isDirectory()) {
                    throw new ValidationException("Parent path " + String.valueOf(parent) + " for Node ID file at " + path + " is not a directory");
                }
                if (!parent.canRead()) {
                    throw new ValidationException("Parent directory " + String.valueOf(parent) + " for Node ID file at " + path + " is not readable");
                }
                if (!parent.canWrite()) {
                    throw new ValidationException("Parent directory " + String.valueOf(parent) + " for Node ID file at " + path + " is not writable");
                }
                return;
            }
            if (!file.isFile()) {
                b.append("a file");
            }
            boolean readable = file.canRead();
            boolean writable = file.canWrite();
            if (!readable) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append("readable");
            }
            boolean bl = empty = file.length() == 0L;
            if (!writable && readable && empty) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append("writable, but it is empty");
            }
            if (b.length() == 0) {
                return;
            }
            throw new ValidationException("Node ID file at path " + path + " isn't " + String.valueOf(b) + ". Please specify the correct path or change the permissions");
        }
    }
}

